/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.gui.components.boxes;

import club.iananderson.seasonhud.Common;
import club.iananderson.seasonhud.client.gui.screens.ColorScreen;
import club.iananderson.seasonhud.config.SeasonHudClient;
import club.iananderson.seasonhud.impl.seasons.CurrentSeason;
import club.iananderson.seasonhud.impl.seasons.Seasons;
import club.iananderson.seasonhud.util.Rgb;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class ColorEditBox
extends class_342 {
    private static final int PADDING = 4;
    private final Seasons boxSeason;
    private final int seasonColor;
    private int newSeasonColor;

    public ColorEditBox(class_327 font, int x, int y, int width, int height, Seasons season) {
        super(font, x, y, width, height, season.getSeasonName());
        this.boxSeason = season;
        this.newSeasonColor = this.seasonColor = season.getSeasonColor();
        this.method_1880(8);
        this.method_1852(String.valueOf(this.seasonColor));
        this.method_1863(colorString -> {
            if (this.validate((String)colorString)) {
                this.method_1868(0xFFFFFF);
                int colorInt = Integer.parseInt(colorString);
                if (colorInt != this.newSeasonColor) {
                    this.newSeasonColor = colorInt;
                    this.method_1852((String)colorString);
                }
                ColorScreen.doneButton.field_22763 = true;
            } else {
                this.method_1868(0xFF5555);
                ColorScreen.doneButton.field_22763 = false;
            }
        });
        this.method_1888(SeasonHudClient.getEnableSeasonNameColor());
    }

    private static EnumSet<Seasons> seasonListSet() {
        Object set = Seasons.SEASONS_ENUM_LIST.clone();
        if (!SeasonHudClient.getShowTropicalSeason() || Common.fabricSeasonsLoaded()) {
            ((AbstractCollection)set).remove((Object)Seasons.DRY);
            ((AbstractCollection)set).remove((Object)Seasons.WET);
        }
        return set;
    }

    private boolean inBounds(int color) {
        int minColor = 0;
        int maxColor = 0xFFFFFF;
        return color >= minColor && color <= maxColor;
    }

    public boolean validate(String colorString) {
        try {
            int colorInt = Integer.parseInt(colorString);
            return this.inBounds(colorInt);
        }
        catch (NumberFormatException formatException) {
            return false;
        }
    }

    public void save() {
        Rgb.setRgb(this.boxSeason, this.newSeasonColor);
        this.boxSeason.setSeasonColor(this.newSeasonColor);
    }

    public int getColor() {
        return this.seasonColor;
    }

    public int getNewColor() {
        return this.newSeasonColor;
    }

    public Seasons getSeason() {
        return this.boxSeason;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int widgetTotalSize;
        class_310 mc = class_310.method_1551();
        float textScale = 1.0f;
        int scaledWidth = mc.method_22683().method_4486();
        boolean seasonShort = scaledWidth < (widgetTotalSize = 86 * ColorEditBox.seasonListSet().size());
        class_5250 seasonCombined = CurrentSeason.getInstance(mc).getSeasonMenuText(this.boxSeason, this.newSeasonColor, seasonShort);
        graphics.method_51448().method_22903();
        if (mc.field_1772.method_27525((class_5348)seasonCombined) > this.method_25368() - 4) {
            textScale = ((float)this.method_25368() - 4.0f) / (float)mc.field_1772.method_27525((class_5348)seasonCombined);
        }
        graphics.method_51448().method_22905(textScale, textScale, 1.0f);
        class_327 class_3272 = mc.field_1772;
        int n = (int)(((double)this.method_46426() + (double)this.method_25368() / 2.0) / (double)textScale);
        float f = this.method_46427();
        Objects.requireNonNull(mc.field_1772);
        graphics.method_27534(class_3272, (class_2561)seasonCombined, n, (int)((f - 9.0f * textScale - 4.0f) / textScale), 0xFFFFFF);
        graphics.method_51448().method_22909();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }
}

