/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger;

import antigers.melancholic_hunger.Cake;
import antigers.melancholic_hunger.config.YACLConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class FoodItemTooltips {
    private static final String CONFIG_PREFIX = "gui.melancholic_hunger.regeneration_tooltip.";

    private static void appendTooltip(ItemTooltipEvent event) {
        ChatFormatting formatting;
        String regenerationRate;
        ItemStack stack = event.getItemStack();
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodProperties == null) {
            if (stack.getItem() != Items.CAKE) {
                return;
            }
            foodProperties = Cake.FOOD_PROPERTIES;
        }
        if (!YACLConfig.showFoodItemTooltips()) {
            return;
        }
        int foodNutrition = YACLConfig.getFoodHealth(stack, foodProperties);
        if (foodNutrition <= 0) {
            return;
        }
        List lines = event.getToolTip();
        lines.add(new FoodHealthTextComponent(foodNutrition));
        if (!YACLConfig.gradualHealthRegeneration()) {
            return;
        }
        float regenerationRatio = (float)foodNutrition / foodProperties.saturation();
        if (regenerationRatio <= 0.5f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.super_fast";
            formatting = ChatFormatting.DARK_PURPLE;
        } else if (regenerationRatio <= 0.8f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.very_fast";
            formatting = ChatFormatting.DARK_GREEN;
        } else if (regenerationRatio <= 1.6f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.fast";
            formatting = ChatFormatting.GREEN;
        } else if (regenerationRatio <= 2.5f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.slow";
            formatting = ChatFormatting.RED;
        } else {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.very_slow";
            formatting = ChatFormatting.DARK_RED;
        }
        lines.add(Component.translatable((String)"gui.melancholic_hunger.regeneration_tooltip.template", (Object[])new Object[]{Component.translatable((String)regenerationRate)}).setStyle(Style.EMPTY.withColor(formatting.getColor().intValue())));
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(FoodItemTooltips::appendTooltip);
    }

    public record FoodHealthTextComponent(int foodNutrition) implements Component,
    FormattedCharSequence
    {
        static List<Component> emptySiblings = new ArrayList<Component>();

        public Style getStyle() {
            return Style.EMPTY;
        }

        public ComponentContents getContents() {
            return PlainTextContents.EMPTY;
        }

        public List<Component> getSiblings() {
            return emptySiblings;
        }

        public FormattedCharSequence getVisualOrderText() {
            return this;
        }

        public boolean accept(FormattedCharSink visitor) {
            return StringDecomposer.iterateFormatted((FormattedText)this, (Style)this.getStyle(), (FormattedCharSink)visitor);
        }

        public FoodHealthTooltipComponent getComponent() {
            return new FoodHealthTooltipComponent(this.foodNutrition);
        }
    }

    public static class FoodHealthTooltipComponent
    implements ClientTooltipComponent {
        private final int heartsCount;
        private final boolean lastHeartIsHalf;

        FoodHealthTooltipComponent(int foodNutrition) {
            this.heartsCount = (int)Math.ceil((float)foodNutrition / 2.0f);
            this.lastHeartIsHalf = foodNutrition % 2 != 0;
        }

        public int getHeight() {
            return 14;
        }

        public int getWidth(Font font) {
            return this.heartsCount * 9;
        }

        public void renderImage(Font font, int x, int y, GuiGraphics context) {
            y += 2;
            for (int i = 0; i < this.heartsCount - 1; ++i) {
                int textureX = x + i * 9;
                context.blitSprite(Gui.HeartType.CONTAINER.getSprite(false, false, false), textureX, y, 9, 9);
                context.blitSprite(Gui.HeartType.NORMAL.getSprite(false, false, false), textureX, y, 9, 9);
            }
            int textureX = x + (this.heartsCount - 1) * 9;
            context.blitSprite(Gui.HeartType.CONTAINER.getSprite(false, this.lastHeartIsHalf, false), textureX, y, 9, 9);
            context.blitSprite(Gui.HeartType.NORMAL.getSprite(false, this.lastHeartIsHalf, false), textureX, y, 9, 9);
        }
    }
}

