/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.hud;

import antigers.melancholic_hunger.MelancholicHunger;
import antigers.melancholic_hunger.config.SprintingOption;
import antigers.melancholic_hunger.config.YACLConfig;
import antigers.melancholic_hunger.hud.RestoredHeartsDrawHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.adrenix.nostalgic.helper.gameplay.stamina.StaminaRenderer;
import mod.adrenix.nostalgic.tweak.config.CandyTweak;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;

public class DrawHudContext
extends GuiGraphics {
    private final int offsetX;
    private final int healthBarY;
    private final int hudExperienceOffset;
    private int bubblesBarY;
    private int armorBarY;
    private final RestoredHeartsDrawHelper restoredHeartsDrawHelper;
    public static boolean isDefaultArmorHudTexture;
    private final boolean hasMountHealth;
    private final int mountHealthRows;
    private final boolean playerHasArmor;
    private final boolean shouldRenderStamina;
    private final boolean shouldRenderStaminaInPlaceOfHunger;
    private int staminaBarY;

    public DrawHudContext(Minecraft client, PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, RestoredHeartsDrawHelper restoredHeartsDrawHelper, int hudExperienceOffset, boolean hasMountHealth, int mountHealthRows) {
        super(client, matrices, vertexConsumers);
        this.restoredHeartsDrawHelper = restoredHeartsDrawHelper;
        int windowWidth = this.guiWidth();
        this.offsetX = windowWidth - (windowWidth % 2 == 0 ? 9 : 10);
        this.healthBarY = this.guiHeight() - 32 - hudExperienceOffset;
        this.hudExperienceOffset = hudExperienceOffset;
        this.hasMountHealth = hasMountHealth;
        this.mountHealthRows = mountHealthRows;
        this.playerHasArmor = client.player.getArmorValue() > 0;
        boolean staminaIsEnabled = MelancholicHunger.nostalgicTweaksInstalled && YACLConfig.sprinting() != SprintingOption.DISABLED && (Boolean)GameplayTweak.STAMINA_SPRINT.get() != false;
        this.shouldRenderStamina = staminaIsEnabled && StaminaRenderer.isVisible();
        this.shouldRenderStaminaInPlaceOfHunger = staminaIsEnabled && (Boolean)CandyTweak.HIDE_STAMINA_BAR.get() == false && (Boolean)CandyTweak.HIDE_STAMINA_BAR_INACTIVE.get() == false;
    }

    public RestoredHeartsDrawHelper getHelper() {
        return this.restoredHeartsDrawHelper;
    }

    public void prepareArmorAndBubblesBarsDrawing(int healthBarHighestRowY) {
        int aboveHealthY = healthBarHighestRowY - 3 - this.hudExperienceOffset;
        if (this.hasMountHealth) {
            this.armorBarY = aboveHealthY;
            this.bubblesBarY = aboveHealthY - 10 * (this.mountHealthRows - 1);
        } else if (!YACLConfig.hideHungerBar()) {
            this.armorBarY = aboveHealthY;
            if (this.shouldRenderStamina) {
                this.staminaBarY = this.healthBarY - 10;
                this.bubblesBarY = this.healthBarY - 20;
            } else {
                this.bubblesBarY = this.healthBarY - 10;
            }
        } else if (this.shouldRenderStamina && this.shouldRenderStaminaInPlaceOfHunger) {
            this.armorBarY = aboveHealthY;
            this.staminaBarY = this.healthBarY;
            this.bubblesBarY = this.healthBarY - 10;
        } else {
            this.armorBarY = this.healthBarY;
            this.staminaBarY = this.playerHasArmor ? this.healthBarY - 10 : this.healthBarY;
            this.bubblesBarY = aboveHealthY;
        }
    }

    public int getArmorBarY() {
        return this.armorBarY;
    }

    public int getMirroredX(int x) {
        return this.offsetX - x;
    }

    public int getHealthBarY() {
        return this.healthBarY;
    }

    public int getBubblesBarY() {
        return this.bubblesBarY;
    }

    public boolean getHasMountHealth() {
        return this.hasMountHealth;
    }

    public boolean getShouldRenderStamina() {
        return this.shouldRenderStamina;
    }

    public boolean getShouldRenderStaminaInPlaceOfHunger() {
        return this.shouldRenderStaminaInPlaceOfHunger;
    }

    public void renderStamina() {
        if (this.shouldRenderStamina) {
            StaminaRenderer.render((GuiGraphics)this, (int)(this.guiHeight() - this.staminaBarY));
        }
    }
}

