/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.mixin;

import antigers.melancholic_hunger.hud.DrawHudContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class ClientMixin {
    @Unique
    private static final ResourceLocation ARMOR_FULL_TEXTURE_PATH = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/armor_full.png");

    @Shadow
    public abstract VanillaPackResources getVanillaPackResources();

    @Shadow
    public abstract ResourceManager getResourceManager();

    @Shadow
    public abstract boolean isGameLoadFinished();

    @Inject(method={"onResourceLoadFinished"}, at={@At(value="RETURN")})
    private void melancholic_hunger$onFinishedLoading(Minecraft.GameLoadCookie loadingContext, CallbackInfo ci) {
        if (!this.isGameLoadFinished()) {
            return;
        }
        Optional currentArmorResource = this.getResourceManager().getResource(ARMOR_FULL_TEXTURE_PATH);
        boolean isDefaultArmorHudTexture = currentArmorResource.map(value -> value.sourcePackId().equals("vanilla")).orElse(false);
        if (isDefaultArmorHudTexture) {
            DrawHudContext.isDefaultArmorHudTexture = true;
            return;
        }
        FallbackResourceManager vanillaResourceManager = new FallbackResourceManager(PackType.CLIENT_RESOURCES, "minecraft");
        vanillaResourceManager.push((PackResources)this.getVanillaPackResources());
        Optional vanillaArmorResource = vanillaResourceManager.getResource(ARMOR_FULL_TEXTURE_PATH);
        try {
            byte[] vanillaTexture = ((Resource)vanillaArmorResource.orElseThrow()).open().readAllBytes();
            byte[] currentTexture = ((Resource)currentArmorResource.orElseThrow()).open().readAllBytes();
            DrawHudContext.isDefaultArmorHudTexture = Arrays.equals(vanillaTexture, currentTexture);
        }
        catch (IOException | NoSuchElementException ignored) {
            DrawHudContext.isDefaultArmorHudTexture = false;
        }
    }
}

