/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.components;

import antigers.melancholic_hunger.components.PlayerComponents;
import antigers.melancholic_hunger.config.YACLConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class HealthRegenerationComponent
implements AutoSyncedComponent,
ServerTickingComponent {
    private final TypeToken<HashSet<ConsumedFood>> consumedFoodSetTypeToken = new TypeToken<HashSet<ConsumedFood>>(this){};
    private final class_1657 player;
    private HashSet<ConsumedFood> consumedFoods = new HashSet();
    private int consumedNutrition = 0;
    private final Gson gson = new Gson();

    public HealthRegenerationComponent(class_1657 player) {
        this.player = player;
    }

    public void readData(class_11368 readView) {
        this.consumedNutrition = Math.max(readView.method_71424("consumedNutrition", 0), 0);
        String consumedFoodsStr = readView.method_71428("consumedFoods", "");
        if (!consumedFoodsStr.isEmpty()) {
            this.consumedFoods = (HashSet)this.gson.fromJson(consumedFoodsStr, this.consumedFoodSetTypeToken);
        }
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71465("consumedNutrition", this.consumedNutrition);
        writeView.method_71469("consumedFoods", this.gson.toJson(this.consumedFoods));
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.player;
    }

    public void serverTick() {
        if (!YACLConfig.gradualHealthRegeneration()) {
            return;
        }
        if (this.consumedFoods.isEmpty()) {
            if (this.consumedNutrition != 0) {
                this.consumedNutrition = 0;
                this.sync();
            }
            return;
        }
        HashSet<Integer> digestingFoods = new HashSet<Integer>();
        Iterator<ConsumedFood> iterator = this.consumedFoods.iterator();
        while (iterator.hasNext()) {
            ConsumedFood consumedFood = iterator.next();
            int consumedFoodId = consumedFood.getFoodComponentId();
            if (digestingFoods.contains(consumedFoodId)) continue;
            digestingFoods.add(consumedFoodId);
            if (!consumedFood.tick()) continue;
            boolean needSync = false;
            if (this.consumedNutrition > 0) {
                this.player.method_6025(1.0f);
                --this.consumedNutrition;
                needSync = true;
            }
            if (consumedFood.isFullyDigested()) {
                iterator.remove();
                needSync = true;
            }
            if (!needSync) continue;
            this.sync();
        }
    }

    private void sync() {
        PlayerComponents.HEALTH_REGENERATION.sync((Object)this.player);
    }

    public boolean canEat() {
        if (!YACLConfig.disableHunger()) {
            return this.player.method_7344().method_7587();
        }
        if (!YACLConfig.gradualHealthRegeneration()) {
            return this.player.method_6032() < this.player.method_6063();
        }
        return this.player.method_6032() + (float)this.consumedNutrition < this.player.method_6063();
    }

    public void eat(class_1799 itemStack, class_4174 foodComponent) {
        if (!YACLConfig.disableHunger()) {
            return;
        }
        int foodHealth = YACLConfig.getFoodHealth(itemStack, foodComponent);
        if (YACLConfig.gradualHealthRegeneration()) {
            this.consumedNutrition += foodHealth;
            this.consumedFoods.add(new ConsumedFood(foodComponent));
            this.sync();
        } else {
            this.player.method_6025((float)foodHealth);
        }
    }

    public int getConsumedNutrition() {
        if (!YACLConfig.gradualHealthRegeneration()) {
            return 0;
        }
        return this.consumedNutrition;
    }

    private static class ConsumedFood {
        private final int foodComponentId;
        private final int foodNutrition;
        private int digestedNutrition = 0;
        private int ticksCounter = 0;
        private final int ticksToHeal;

        ConsumedFood(class_4174 foodComponent) {
            this.foodComponentId = foodComponent.hashCode();
            this.foodNutrition = foodComponent.comp_2491();
            this.ticksToHeal = Math.max(1, (int)((float)(this.foodNutrition * 20) / (foodComponent.comp_2492() * YACLConfig.gradualHealthRegenerationSpeed())));
        }

        int getFoodComponentId() {
            return this.foodComponentId;
        }

        boolean isFullyDigested() {
            return this.digestedNutrition >= this.foodNutrition;
        }

        boolean tick() {
            if (this.ticksCounter < this.ticksToHeal) {
                ++this.ticksCounter;
                return false;
            }
            ++this.digestedNutrition;
            this.ticksCounter = 0;
            return true;
        }
    }
}

