/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.config;

import antigers.melancholic_hunger.MelancholicHunger;
import antigers.melancholic_hunger.config.SprintingOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

class ConfigOption<T, U> {
    private static final String CONFIG_PREFIX = "screen.melancholic_hunger.config.";
    protected static final String OPTION_CONFIG_PREFIX = "screen.melancholic_hunger.config.option.";
    protected final String name;
    private final T defaultValue;
    private final boolean nostalgicTweaksRelated;
    protected final Supplier<T> getter;
    protected final Consumer<T> setter;
    protected Option<T> YACLOption;
    private final boolean isServerOption;
    private boolean playerHasPermission;
    private final ArrayList<ConfigOption<?, T>> dependents = new ArrayList();
    @Nullable
    private ConfigOptionDependency<?> dependency;
    @Nullable
    private T valueOnDependencyTrue;
    @Nullable
    private T valueOnDependencyFalse;

    public ConfigOption(String name, T defaultValue, boolean nostalgicTweaksRelated, boolean isServerOption, Supplier<T> getter, Consumer<T> setter) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.nostalgicTweaksRelated = nostalgicTweaksRelated;
        this.getter = getter;
        this.setter = setter;
        this.isServerOption = isServerOption;
        this.playerHasPermission = true;
    }

    public static boolean getPlayerHasPermission() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        return client.method_47392() || player == null || player.method_64475(2);
    }

    protected void setValueToDefault() {
        this.setter.accept(this.defaultValue);
    }

    public void validateValue() {
        if (this.getter.get() == null) {
            this.setValueToDefault();
        }
        this.updateValueAccordingToDependency();
    }

    protected void updateValueAccordingToDependency() {
        if (this.dependency != null && !this.dependency.isCurrentValueEqualsRequired()) {
            this.setValueForced(this.valueOnDependencyFalse);
        }
    }

    protected void updateDependents() {
        for (ConfigOption<?, T> dependent : this.dependents) {
            dependent.updateValueAccordingToDependency();
        }
    }

    private void setValueForced(T value) {
        if (value == null || this.getter.get() == value) {
            return;
        }
        this.setter.accept(value);
        this.updateDependents();
    }

    public void setValue(T value) {
        if (this.dependency == null || this.dependency.isCurrentValueEqualsRequired()) {
            this.setValueForced(value);
        }
    }

    public ConfigOption<T, U> addValueDependency(ConfigOption<U, ?> configOption, U requiredValue, T valueOnTrue, T valueOnFalse) {
        this.valueOnDependencyTrue = valueOnTrue;
        this.valueOnDependencyFalse = valueOnFalse;
        return this.addDependency(configOption, requiredValue);
    }

    public ConfigOption<T, U> addDependency(ConfigOption<U, ?> dependencyOption, U requiredValue) {
        this.dependency = new ConfigOptionDependency<U>(dependencyOption, requiredValue);
        dependencyOption.dependents.add(this);
        return this;
    }

    protected OptionDescription buildOptionDescription(T value) {
        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)(OPTION_CONFIG_PREFIX + this.name + ".description"))});
        if (MelancholicHunger.nostalgicTweaksInstalled && this.nostalgicTweaksRelated) {
            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n"), class_2561.method_43471((String)"screen.melancholic_hunger.config.nostalgic_tweaks_controlled_option").method_10862(class_2583.field_24360.method_36139(0x969696).method_10978(Boolean.valueOf(true)))});
        }
        if (!this.playerHasPermission) {
            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n"), class_2561.method_43471((String)"screen.melancholic_hunger.config.op_privileges_required_option").method_10862(class_2583.field_24360.method_36139(0xFF5555).method_10978(Boolean.valueOf(true)))});
        } else if (this.dependency != null && !this.dependency.isPendingValueEqualsRequired()) {
            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n"), class_2561.method_43469((String)"screen.melancholic_hunger.config.dependency_required_option", (Object[])new Object[]{class_2561.method_43471((String)(OPTION_CONFIG_PREFIX + this.dependency.configOption.name + ".name")), this.dependency.getDependentOptionDescription()}).method_10862(class_2583.field_24360.method_36139(15118857).method_10978(Boolean.valueOf(true)))});
        }
        return descriptionBuilder.build();
    }

    private void addDependencyListeners() {
        if (this.dependency == null) {
            return;
        }
        Option<T> dependencyYACLOption = this.dependency.configOption.YACLOption;
        if (this.valueOnDependencyTrue != null || this.valueOnDependencyFalse != null) {
            dependencyYACLOption.addEventListener((option, event) -> {
                T new_value;
                if (event != OptionEventListener.Event.STATE_CHANGE) {
                    return;
                }
                T t = new_value = this.dependency.isPendingValueEqualsRequired() ? this.valueOnDependencyTrue : this.valueOnDependencyFalse;
                if (new_value != null) {
                    this.YACLOption.requestSet(new_value);
                }
            });
        }
        dependencyYACLOption.addEventListener((option, event) -> {
            if (event != OptionEventListener.Event.STATE_CHANGE) {
                return;
            }
            Object currentValue = this.YACLOption.pendingValue();
            this.YACLOption.setAvailable(this.dependency.isPendingValueEqualsRequired());
            this.YACLOption.requestSet(currentValue);
        });
    }

    protected boolean getOptionAvailability() {
        if (this.isServerOption) {
            this.playerHasPermission = ConfigOption.getPlayerHasPermission();
        }
        if (this.playerHasPermission) {
            if (this.dependency == null) {
                return true;
            }
            this.addDependencyListeners();
            return this.dependency.isCurrentValueEqualsRequired();
        }
        return false;
    }

    public Option<T> buildYACLOption(Function<Option<T>, ControllerBuilder<T>> controllerBuilder) {
        this.YACLOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)(OPTION_CONFIG_PREFIX + this.name + ".name"))).binding(this.defaultValue, this.getter, this.setter).controller(controllerBuilder).available(this.getOptionAvailability()).description(this::buildOptionDescription).build();
        return this.YACLOption;
    }

    public void forgetPendingValueIfServerOption() {
        if (this.isServerOption) {
            this.YACLOption.forgetPendingValue();
        }
    }

    public record ConfigOptionDependency<U>(ConfigOption<U, ?> configOption, U requiredValue) {
        boolean isCurrentValueEqualsRequired() {
            Object value = this.configOption.getter.get();
            if (value == null) {
                this.configOption.validateValue();
                value = this.configOption.getter.get();
            }
            return this.requiredValue.equals(value);
        }

        boolean isPendingValueEqualsRequired() {
            return this.configOption.YACLOption.pendingValue().equals(this.requiredValue);
        }

        class_2561 getDependentOptionDescription() {
            Object value = this.configOption.YACLOption.pendingValue();
            if (value instanceof Boolean) {
                Boolean valueBool = (Boolean)value;
                return valueBool != false ? class_2561.method_43471((String)"screen.melancholic_hunger.config.dependency_required_value_enabled") : class_2561.method_43471((String)"screen.melancholic_hunger.config.dependency_required_value_not_enabled");
            }
            return class_2561.method_43469((String)"screen.melancholic_hunger.config.dependency_required_value_not_set_to", (Object[])new Object[]{this.requiredValue == SprintingOption.LIMITED_BY_HEALTH ? class_2561.method_43471((String)"screen.melancholic_hunger.config.sprinting_limited_by_health_option") : this.requiredValue.toString()});
        }
    }
}

