/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.hud;

import antigers.melancholic_hunger.components.HealthRegenerationComponent;
import antigers.melancholic_hunger.components.PlayerComponents;
import antigers.melancholic_hunger.config.YACLConfig;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_5819;
import net.minecraft.class_9334;

public class RestoredHeartsDrawHelper {
    private final int playerHealth;
    private int currentHeart;
    private final int totalNutritionToDraw;
    private final int heldFoodNutrition;
    private final int consumedNutrition;
    private int absorption;
    private int currentY;
    private final class_5819 random;
    private final int sprintingHealthLimit;
    private final boolean highlightRegeneratedHearts;
    private final boolean highlightRestoredHearts;
    private final int regeneratingHeartColor = this.calculateBlinkingColor();
    private final class_329.class_6411 heartType;

    public RestoredHeartsDrawHelper(class_1657 player, class_5819 random) {
        this.heartType = class_329.class_6411.method_37301((class_1657)player);
        this.playerHealth = class_3532.method_15386((float)player.method_6032());
        this.absorption = class_3532.method_15386((float)player.method_6067());
        class_1799 heldItemStack = player.method_6047();
        class_4174 foodComponent = (class_4174)heldItemStack.method_58694(class_9334.field_50075);
        this.currentHeart = class_3532.method_15386((float)player.method_6063());
        this.random = random;
        this.sprintingHealthLimit = YACLConfig.sprintingHealthLimit();
        this.highlightRegeneratedHearts = YACLConfig.highlightRegeneratedHearts();
        this.highlightRestoredHearts = YACLConfig.highlightRestoredHearts();
        this.consumedNutrition = ((HealthRegenerationComponent)PlayerComponents.HEALTH_REGENERATION.get((Object)player)).getConsumedNutrition();
        this.heldFoodNutrition = foodComponent != null ? YACLConfig.getFoodHealth(heldItemStack, foodComponent) : 0;
        this.totalNutritionToDraw = this.highlightRegeneratedHearts ? this.consumedNutrition + this.heldFoodNutrition : this.heldFoodNutrition;
    }

    private int calculateBlinkingColor() {
        return (int)class_3532.method_15379((float)(class_3532.method_15374((float)((float)(class_156.method_658() % 1500L) / 1500.0f * ((float)Math.PI * 2))) * 155.0f)) + 50;
    }

    public Pair<RestoredHeart, RestoredHeart> heartsToDraw() {
        int heartsDiff = this.currentHeart - this.playerHealth - 1;
        if (heartsDiff < 0) {
            return new Pair(null, null);
        }
        if (this.highlightRegeneratedHearts && this.consumedNutrition > 0 && heartsDiff <= this.consumedNutrition) {
            boolean isHalf = heartsDiff == this.consumedNutrition;
            RestoredHeart regeneratingHeart = new RestoredHeart(this.heartType, isHalf, this.regeneratingHeartColor, this.regeneratingHeartColor, this.regeneratingHeartColor);
            if (isHalf && this.highlightRestoredHearts && this.heldFoodNutrition > 0) {
                return new Pair((Object)new RestoredHeart(class_329.class_6411.field_33945, false, 120, 70, 70), (Object)regeneratingHeart);
            }
            return new Pair((Object)regeneratingHeart, null);
        }
        if (this.highlightRestoredHearts && this.totalNutritionToDraw > 0 && heartsDiff <= this.totalNutritionToDraw) {
            return new Pair((Object)new RestoredHeart(class_329.class_6411.field_33945, heartsDiff == this.totalNutritionToDraw, 120, 70, 70), null);
        }
        return new Pair(null, null);
    }

    public void updateCurrentHeart() {
        if (this.absorption <= 0) {
            this.currentHeart -= 2;
        } else {
            this.absorption -= 2;
        }
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public int updateCurrentY(int y) {
        if (this.playerHealth <= this.sprintingHealthLimit) {
            y += this.random.method_43048(2);
        }
        this.currentY = y;
        return y;
    }

    public record RestoredHeart(class_329.class_6411 heartType, boolean isHalf, int colorRed, int colorGreen, int colorBlue) {
    }
}

