/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.components;

import antigers.melancholic_hunger.components.PlayerComponents;
import antigers.melancholic_hunger.config.YACLConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.Nullable;

public class HealthRegenerationComponent
implements INBTSerializable<CompoundTag> {
    private final TypeToken<HashSet<ConsumedFood>> consumedFoodSetTypeToken = new TypeToken<HashSet<ConsumedFood>>(this){};
    private final Player player;
    private HashSet<ConsumedFood> consumedFoods = new HashSet();
    private int consumedNutrition = 0;
    private final Gson gson = new Gson();

    public HealthRegenerationComponent(Player player) {
        this.player = player;
    }

    public void deserializeNBT(@Nullable HolderLookup.Provider provider, CompoundTag tag) {
        this.consumedNutrition = Math.max(tag.getInt("consumedNutrition"), 0);
        String consumedFoodsStr = tag.getString("consumedFoods");
        if (!consumedFoodsStr.isEmpty()) {
            this.consumedFoods = (HashSet)this.gson.fromJson(consumedFoodsStr, this.consumedFoodSetTypeToken);
        }
    }

    public CompoundTag serializeNBT(@Nullable HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("consumedNutrition", this.consumedNutrition);
        tag.putString("consumedFoods", this.gson.toJson(this.consumedFoods));
        return tag;
    }

    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            ((HealthRegenerationComponent)player.getData(PlayerComponents.HEALTH_REGENERATION)).serverTick();
        }
    }

    private void serverTick() {
        if (!YACLConfig.gradualHealthRegeneration()) {
            return;
        }
        if (this.consumedFoods.isEmpty()) {
            if (this.consumedNutrition != 0) {
                this.consumedNutrition = 0;
                this.sync();
            }
            return;
        }
        HashSet<Integer> digestingFoods = new HashSet<Integer>();
        Iterator<ConsumedFood> iterator = this.consumedFoods.iterator();
        while (iterator.hasNext()) {
            ConsumedFood consumedFood = iterator.next();
            int consumedFoodId = consumedFood.getFoodComponentId();
            if (digestingFoods.contains(consumedFoodId)) continue;
            digestingFoods.add(consumedFoodId);
            if (!consumedFood.tick()) continue;
            boolean needSync = false;
            if (this.consumedNutrition > 0) {
                this.player.heal(1.0f);
                --this.consumedNutrition;
                needSync = true;
            }
            if (consumedFood.isFullyDigested()) {
                iterator.remove();
                needSync = true;
            }
            if (!needSync) continue;
            this.sync();
        }
    }

    private void sync() {
        this.player.syncData(PlayerComponents.HEALTH_REGENERATION);
    }

    public boolean canEat() {
        if (!YACLConfig.disableHunger()) {
            return this.player.getFoodData().needsFood();
        }
        if (!YACLConfig.gradualHealthRegeneration()) {
            return this.player.getHealth() < this.player.getMaxHealth();
        }
        return this.player.getHealth() + (float)this.consumedNutrition < this.player.getMaxHealth();
    }

    public void eat(ItemStack itemStack, FoodProperties foodComponent) {
        if (!YACLConfig.disableHunger()) {
            return;
        }
        int foodHealth = YACLConfig.getFoodHealth(itemStack, foodComponent);
        if (YACLConfig.gradualHealthRegeneration()) {
            this.consumedNutrition += foodHealth;
            this.consumedFoods.add(new ConsumedFood(foodComponent, foodHealth));
            this.sync();
        } else {
            this.player.heal((float)foodHealth);
        }
    }

    public int getConsumedNutrition() {
        if (!YACLConfig.gradualHealthRegeneration()) {
            return 0;
        }
        return this.consumedNutrition;
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(HealthRegenerationComponent::onPlayerTick);
    }

    private static class ConsumedFood {
        private final int foodComponentId;
        private final int foodNutrition;
        private int digestedNutrition = 0;
        private int ticksCounter = 0;
        private final int ticksToHeal;

        ConsumedFood(FoodProperties foodComponent, int foodNutrition) {
            this.foodComponentId = foodComponent.hashCode();
            this.foodNutrition = foodNutrition;
            this.ticksToHeal = Math.max(1, (int)((float)(foodNutrition * 20) / (foodComponent.saturation() * YACLConfig.gradualHealthRegenerationSpeed())));
        }

        int getFoodComponentId() {
            return this.foodComponentId;
        }

        boolean isFullyDigested() {
            return this.digestedNutrition >= this.foodNutrition;
        }

        boolean tick() {
            if (this.ticksCounter < this.ticksToHeal) {
                ++this.ticksCounter;
                return false;
            }
            ++this.digestedNutrition;
            this.ticksCounter = 0;
            return true;
        }
    }
}

