/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.components;

import antigers.melancholic_hunger.MelancholicHunger;
import antigers.melancholic_hunger.config.ServerConfigData;
import antigers.melancholic_hunger.config.YACLConfig;
import antigers.melancholic_hunger.nostalgic_tweaks.NostalgicTweaksConfigHandlerWriter;
import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.tweak.factory.Tweak;
import mod.adrenix.nostalgic.tweak.factory.TweakMeta;
import mod.adrenix.nostalgic.tweak.factory.TweakPool;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ServerConfigComponent {
    public static final StreamCodec<ByteBuf, ServerConfigData.ImmutableServerConfigData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerConfigData.ImmutableServerConfigData::toJson, ServerConfigData.ImmutableServerConfigData::fromJson);

    public static void syncAllPlayers() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)YACLConfig.getServerData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void syncAllPlayersExceptOf(int ignoredPlayerId) {
        ServerConfigData.ImmutableServerConfigData data = YACLConfig.getServerData();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            if (player.getId() == ignoredPlayerId) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)data, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void syncNostalgicTweaksToAllPlayers() {
        TweakPool.filter((Predicate[])new Predicate[]{Tweak::isMultiplayerLike}).forEach(TweakMeta::sendToAll);
    }

    public static void registerPayloadHandlersEventHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar = registrar.executesOn(HandlerThread.NETWORK);
        registrar.commonBidirectional(ServerConfigData.TYPE, STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler((data, context) -> {
            if (!Minecraft.getInstance().isSingleplayer()) {
                YACLConfig.setServerData(data);
                NostalgicTweaksConfigHandlerWriter handler = (NostalgicTweaksConfigHandlerWriter)ConfigBuilder.getHandler();
                handler.melancholic_hunger$writeConfigToNT(YACLConfig.getServerData(), YACLConfig.getClientData());
            }
        }, (data, context) -> {
            if (!context.player().hasPermissions(2)) {
                return;
            }
            boolean dataUpdated = YACLConfig.setServerData(data);
            if (!dataUpdated) {
                return;
            }
            if (MelancholicHunger.nostalgicTweaksInstalled) {
                NostalgicTweaksConfigHandlerWriter handler = (NostalgicTweaksConfigHandlerWriter)ConfigBuilder.getHandler();
                handler.melancholic_hunger$writeConfigToNT(YACLConfig.getServerData(), null);
                ServerConfigComponent.syncNostalgicTweaksToAllPlayers();
            }
            ServerConfigComponent.syncAllPlayersExceptOf(context.player().getId());
            YACLConfig.saveToDisk();
        }));
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)YACLConfig.getServerData(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToServer(ServerConfigData.ImmutableServerConfigData serverConfigData) {
        PacketDistributor.sendToServer((CustomPacketPayload)serverConfigData, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void register(IEventBus modBus) {
        modBus.addListener(ServerConfigComponent::registerPayloadHandlersEventHandler);
        NeoForge.EVENT_BUS.addListener(ServerConfigComponent::onPlayerLogin);
    }
}

