/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.hud;

import antigers.melancholic_hunger.components.HealthRegenerationComponent;
import antigers.melancholic_hunger.components.PlayerComponents;
import antigers.melancholic_hunger.config.YACLConfig;
import com.mojang.datafixers.util.Pair;
import net.minecraft.Util;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class RestoredHeartsDrawHelper {
    private final int playerHealth;
    private int currentHeart;
    private final int totalNutritionToDraw;
    private final int heldFoodNutrition;
    private final int consumedNutrition;
    private int absorption;
    private int currentY;
    private final RandomSource random;
    private final int sprintingHealthLimit;
    private final boolean highlightRegeneratedHearts;
    private final boolean highlightRestoredHearts;
    private final int regeneratingHeartColor = this.calculateBlinkingColor();
    private final Gui.HeartType heartType;

    public RestoredHeartsDrawHelper(Player player, RandomSource random) {
        this.heartType = Gui.HeartType.forPlayer((Player)player);
        this.playerHealth = Mth.ceil((float)player.getHealth());
        this.absorption = Mth.ceil((float)player.getAbsorptionAmount());
        ItemStack heldItemStack = player.getMainHandItem();
        FoodProperties foodComponent = (FoodProperties)heldItemStack.get(DataComponents.FOOD);
        this.currentHeart = Mth.ceil((float)player.getMaxHealth());
        this.random = random;
        this.sprintingHealthLimit = YACLConfig.sprintingHealthLimit();
        this.highlightRegeneratedHearts = YACLConfig.highlightRegeneratedHearts();
        this.highlightRestoredHearts = YACLConfig.highlightRestoredHearts();
        this.consumedNutrition = ((HealthRegenerationComponent)player.getData(PlayerComponents.HEALTH_REGENERATION)).getConsumedNutrition();
        this.heldFoodNutrition = foodComponent != null ? YACLConfig.getFoodHealth(heldItemStack, foodComponent) : 0;
        this.totalNutritionToDraw = this.highlightRegeneratedHearts ? this.consumedNutrition + this.heldFoodNutrition : this.heldFoodNutrition;
    }

    private int calculateBlinkingColor() {
        return (int)Mth.abs((float)(Mth.sin((float)((float)(Util.getMillis() % 1500L) / 1500.0f * ((float)Math.PI * 2))) * 155.0f)) + 50;
    }

    public Pair<RestoredHeart, RestoredHeart> heartsToDraw() {
        int heartsDiff = this.currentHeart - this.playerHealth - 1;
        if (heartsDiff < 0) {
            return new Pair(null, null);
        }
        if (this.highlightRegeneratedHearts && this.consumedNutrition > 0 && heartsDiff <= this.consumedNutrition) {
            boolean isHalf = heartsDiff == this.consumedNutrition;
            RestoredHeart regeneratingHeart = new RestoredHeart(this.heartType, isHalf, this.regeneratingHeartColor, this.regeneratingHeartColor, this.regeneratingHeartColor);
            if (isHalf && this.highlightRestoredHearts && this.heldFoodNutrition > 0) {
                return new Pair((Object)new RestoredHeart(Gui.HeartType.NORMAL, false, 120, 70, 70), (Object)regeneratingHeart);
            }
            return new Pair((Object)regeneratingHeart, null);
        }
        if (this.highlightRestoredHearts && this.totalNutritionToDraw > 0 && heartsDiff <= this.totalNutritionToDraw) {
            return new Pair((Object)new RestoredHeart(Gui.HeartType.NORMAL, heartsDiff == this.totalNutritionToDraw, 120, 70, 70), null);
        }
        return new Pair(null, null);
    }

    public void updateCurrentHeart() {
        if (this.absorption <= 0) {
            this.currentHeart -= 2;
        } else {
            this.absorption -= 2;
        }
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public int updateCurrentY(int y) {
        if (this.playerHealth <= this.sprintingHealthLimit) {
            y += this.random.nextInt(2);
        }
        this.currentY = y;
        return y;
    }

    public record RestoredHeart(Gui.HeartType heartType, boolean isHalf, int colorRed, int colorGreen, int colorBlue) {
    }
}

