/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.mixin;

import antigers.melancholic_hunger.MelancholicHungerClient;
import antigers.melancholic_hunger.compat.RaisedCompat;
import antigers.melancholic_hunger.config.YACLConfig;
import antigers.melancholic_hunger.hud.DrawHudContext;
import antigers.melancholic_hunger.hud.ExperienceBarAnimation;
import antigers.melancholic_hunger.hud.ExperienceHudRenderer;
import antigers.melancholic_hunger.hud.RestoredHeartsDrawHelper;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Gui.class})
public abstract class InGameHudMixin
implements ExperienceHudRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    private static ResourceLocation ARMOR_EMPTY_SPRITE;
    @Shadow
    @Final
    private static ResourceLocation ARMOR_HALF_SPRITE;
    @Unique
    private static final ResourceLocation VANILLA_ARMOR_EMPTY_TEXTURE;
    @Unique
    private static final ResourceLocation VANILLA_ARMOR_HALF_TEXTURE;
    @Unique
    private static final ResourceLocation VANILLA_ARMOR_HALF_TEXTURE_INVERSED;
    @Unique
    private final ExperienceBarAnimation melancholic_hunger$experienceBarAnimation = new ExperienceBarAnimation();

    @Shadow
    private void renderExperienceLevel(GuiGraphics context, DeltaTracker tickCounter) {
    }

    @Shadow
    @Nullable
    protected abstract Player getCameraPlayer();

    @Shadow
    private void renderExperienceBar(GuiGraphics context, int x) {
    }

    @Shadow
    protected abstract boolean isExperienceBarVisible();

    @Shadow
    protected abstract int getVehicleMaxHearts(@Nullable LivingEntity var1);

    @Shadow
    protected abstract int getVisibleVehicleHeartRows(int var1);

    @Shadow
    @Nullable
    protected abstract LivingEntity getPlayerVehicleWithHealth();

    @WrapOperation(method={"renderExperienceBar"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;guiHeight()I")})
    private int melancholic_hunger$modifyExpBarY(GuiGraphics instance, Operation<Integer> original) {
        return (Integer)original.call(new Object[]{instance}) - this.melancholic_hunger$experienceBarAnimation.getCurrentPos() + 7;
    }

    @WrapOperation(method={"renderExperienceLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;guiHeight()I")})
    private int melancholic_hunger$modifyExpLevelY(GuiGraphics instance, Operation<Integer> original) {
        return (Integer)original.call(new Object[]{instance}) - this.melancholic_hunger$experienceBarAnimation.getCurrentPos() + 7;
    }

    @WrapOperation(method={"renderVehicleHealth"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;guiHeight()I")})
    private int melancholic_hunger$moveMountHealthBar(GuiGraphics drawContext, Operation<Integer> original) {
        if (this.minecraft.player.jumpableVehicle() == null) {
            return (Integer)original.call(new Object[]{drawContext}) - this.melancholic_hunger$experienceBarAnimation.getCurrentPos() + 7;
        }
        return (Integer)original.call(new Object[]{drawContext});
    }

    @WrapMethod(method={"renderExperienceBar"})
    private void melancholic_hunger$addExperienceBarShading(GuiGraphics context, int x, Operation<Void> original) {
        float currentOpacity = this.melancholic_hunger$experienceBarAnimation.getCurrentOpacity();
        context.setColor(1.0f, 1.0f, 1.0f, currentOpacity);
        original.call(new Object[]{context, x});
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @WrapMethod(method={"renderExperienceLevel"})
    private void melancholic_hunger$addExperienceLevelShading(GuiGraphics context, DeltaTracker tickCounter, Operation<Void> original) {
        float currentOpacity = this.melancholic_hunger$experienceBarAnimation.getCurrentOpacity();
        context.setColor(1.0f, 1.0f, 1.0f, currentOpacity);
        original.call(new Object[]{context, tickCounter});
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Unique
    public boolean melancholic_hunger$needToRenderExperienceHudOnCurrentScreen() {
        if (!this.isExperienceBarVisible()) {
            return false;
        }
        Screen currentScreen = this.minecraft.screen;
        return YACLConfig.showExperienceInInventory() && currentScreen instanceof InventoryScreen || YACLConfig.showExperienceOnScreens() && (currentScreen instanceof FurnaceScreen || currentScreen instanceof BlastFurnaceScreen || currentScreen instanceof SmokerScreen || currentScreen instanceof EnchantmentScreen || currentScreen instanceof AnvilScreen || currentScreen instanceof GrindstoneScreen);
    }

    @Override
    public void melancholic_hunger$renderExperienceHud(GuiGraphics drawContext) {
        if (YACLConfig.renderExperienceOverBackground() && this.melancholic_hunger$needToRenderExperienceHudOnCurrentScreen()) {
            if (MelancholicHungerClient.raisedInstalled) {
                RaisedCompat.startHotbarTranslate(drawContext);
            }
            this.renderExperienceBar(drawContext, drawContext.guiWidth() / 2 - 91);
            this.renderExperienceLevel(drawContext, null);
            if (MelancholicHungerClient.raisedInstalled) {
                RaisedCompat.endTranslate(drawContext);
            }
        }
    }

    @Override
    public void melancholic_hunger$onAddExperience() {
        if (YACLConfig.showExperienceOnGain()) {
            this.melancholic_hunger$experienceBarAnimation.onGainExperience();
        }
    }

    @WrapMethod(method={"render"})
    private void melancholic_hunger$replaceDrawContext(GuiGraphics guiGraphics, DeltaTracker deltaTracker, Operation<Void> original) {
        Player playerEntity = this.getCameraPlayer();
        if (playerEntity == null) {
            return;
        }
        this.melancholic_hunger$experienceBarAnimation.update(this.melancholic_hunger$needToRenderExperienceHudOnCurrentScreen());
        RestoredHeartsDrawHelper drawRestoredHeartsHelper = new RestoredHeartsDrawHelper(playerEntity, this.random);
        int mountHealthHeartCount = this.getVehicleMaxHearts(this.getPlayerVehicleWithHealth());
        boolean hasMountHealth = mountHealthHeartCount > 0;
        int mountHealthRows = this.getVisibleVehicleHeartRows(mountHealthHeartCount);
        DrawHudContext drawHudContext = new DrawHudContext(this.minecraft, guiGraphics.pose(), guiGraphics.bufferSource(), drawRestoredHeartsHelper, this.minecraft.player.jumpableVehicle() != null ? 7 : this.melancholic_hunger$experienceBarAnimation.getCurrentPos(), hasMountHealth, mountHealthRows);
        original.call(new Object[]{drawHudContext, deltaTracker});
    }

    @WrapMethod(method={"renderFood"})
    private void melancholic_hunger$disableHungerBar(GuiGraphics guiGraphics, Player player, int y, int x, Operation<Void> original) {
        DrawHudContext drawHudContext = (DrawHudContext)guiGraphics;
        if (!YACLConfig.hideHungerBar()) {
            original.call(new Object[]{guiGraphics, player, drawHudContext.getHealthBarY(), x});
        }
        drawHudContext.renderStamina();
    }

    @WrapMethod(method={"renderArmor"})
    private static void melancholic_hunger$wrapRenderArmor(GuiGraphics drawContext, Player player, int i, int j, int k, int x, Operation<Void> original) {
        DrawHudContext drawHudContext = (DrawHudContext)drawContext;
        drawHudContext.prepareArmorAndBubblesBarsDrawing(i - (j - 1) * k);
        original.call(new Object[]{drawContext, player, i, j, k, x});
    }

    @Unique
    private static void melancholic_hunger$drawGuiTextureInversed(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int width, int height) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(texture);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = drawContext.pose().last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float u1 = sprite.getU0();
        float u2 = sprite.getU1();
        float v1 = sprite.getV0();
        float v2 = sprite.getV1();
        builder.addVertex(matrix4f, (float)x, (float)(y + height), 0.0f).setUv(u2, v2);
        builder.addVertex(matrix4f, (float)(x + width), (float)(y + height), 0.0f).setUv(u1, v2);
        builder.addVertex(matrix4f, (float)(x + width), (float)y, 0.0f).setUv(u1, v1);
        builder.addVertex(matrix4f, (float)x, (float)y, 0.0f).setUv(u2, v1);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    @Unique
    private static ResourceLocation melancholic_hunger$fixVanillaArmorTexture(ResourceLocation texture, boolean inversed) {
        if (texture == ARMOR_HALF_SPRITE) {
            return inversed ? VANILLA_ARMOR_HALF_TEXTURE_INVERSED : VANILLA_ARMOR_HALF_TEXTURE;
        }
        if (texture == ARMOR_EMPTY_SPRITE) {
            return VANILLA_ARMOR_EMPTY_TEXTURE;
        }
        return texture;
    }

    @WrapOperation(method={"renderArmor"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V")})
    private static void melancholic_hunger$moveArmorBar(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int width, int height, Operation<Void> original) {
        DrawHudContext drawHudContext = (DrawHudContext)drawContext;
        y = drawHudContext.getArmorBarY();
        if (YACLConfig.hideHungerBar() && !drawHudContext.getShouldRenderStaminaInPlaceOfHunger() && !drawHudContext.getHasMountHealth()) {
            x = drawHudContext.getMirroredX(x);
            if (!DrawHudContext.isDefaultArmorHudTexture) {
                InGameHudMixin.melancholic_hunger$drawGuiTextureInversed(drawContext, texture, x, y, width, height);
                return;
            }
            texture = InGameHudMixin.melancholic_hunger$fixVanillaArmorTexture(texture, true);
        } else if (DrawHudContext.isDefaultArmorHudTexture) {
            texture = InGameHudMixin.melancholic_hunger$fixVanillaArmorTexture(texture, false);
        }
        original.call(new Object[]{drawContext, texture, x, y, width, height});
    }

    @WrapMethod(method={"renderHearts"})
    private void melancholic_hunger$moveHealthBar(GuiGraphics guiGraphics, Player player, int x, int y, int height, int offsetHeartIndex, float maxHealth, int currentHealth, int displayHealth, int absorptionAmount, boolean renderHighlight, Operation<Void> original) {
        DrawHudContext drawHudContext = (DrawHudContext)guiGraphics;
        original.call(new Object[]{guiGraphics, player, x, drawHudContext.getHealthBarY(), height, offsetHeartIndex, Float.valueOf(maxHealth), currentHealth, displayHealth, absorptionAmount, renderHighlight});
    }

    @Unique
    private void melancholic_hunger$drawHeartWithColor(GuiGraphics context, Gui.HeartType type, int x, int y, boolean hardcore, boolean blinking, boolean half, int colorRed, int colorGreen, int colorBlue) {
        context.setColor((float)colorRed / 255.0f, (float)colorGreen / 255.0f, (float)colorBlue / 255.0f, 1.0f);
        context.blitSprite(type.getSprite(hardcore, half, blinking), x, y, 9, 9);
        context.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @WrapOperation(method={"renderHearts"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIZZZ)V")})
    private void melancholic_hunger$drawRestoredHearts(Gui inGameHud, GuiGraphics drawContext, Gui.HeartType type, int x, int y, boolean hardcore, boolean blinking, boolean half, Operation<Void> original) {
        DrawHudContext drawHudContext = (DrawHudContext)drawContext;
        RestoredHeartsDrawHelper restoredHeartsDrawHelper = drawHudContext.getHelper();
        if (type != Gui.HeartType.CONTAINER) {
            original.call(new Object[]{inGameHud, drawContext, type, x, restoredHeartsDrawHelper.getCurrentY(), hardcore, blinking, half});
            return;
        }
        y = restoredHeartsDrawHelper.updateCurrentY(y);
        Pair<RestoredHeartsDrawHelper.RestoredHeart, RestoredHeartsDrawHelper.RestoredHeart> res = restoredHeartsDrawHelper.heartsToDraw();
        RestoredHeartsDrawHelper.RestoredHeart firstHeart = (RestoredHeartsDrawHelper.RestoredHeart)res.getFirst();
        if (firstHeart != null) {
            original.call(new Object[]{inGameHud, drawContext, Gui.HeartType.CONTAINER, x, y, hardcore, blinking, half});
            this.melancholic_hunger$drawHeartWithColor(drawContext, firstHeart.heartType(), x, y, hardcore, blinking, firstHeart.isHalf(), firstHeart.colorRed(), firstHeart.colorGreen(), firstHeart.colorBlue());
            RestoredHeartsDrawHelper.RestoredHeart secondHeart = (RestoredHeartsDrawHelper.RestoredHeart)res.getSecond();
            if (secondHeart != null) {
                this.melancholic_hunger$drawHeartWithColor(drawContext, secondHeart.heartType(), x, y, hardcore, blinking, secondHeart.isHalf(), secondHeart.colorRed(), secondHeart.colorGreen(), secondHeart.colorBlue());
            }
        } else {
            original.call(new Object[]{inGameHud, drawContext, type, x, y, hardcore, blinking, half});
        }
        restoredHeartsDrawHelper.updateCurrentHeart();
    }

    @WrapOperation(method={"renderAirLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V")})
    private void melancholic_hunger$moveBubblesBar(GuiGraphics drawContext, ResourceLocation texture, int x, int y, int width, int height, Operation<Void> original) {
        DrawHudContext drawHudContext = (DrawHudContext)drawContext;
        if (!(drawHudContext.getShouldRenderStamina() && drawHudContext.getShouldRenderStaminaInPlaceOfHunger() || !YACLConfig.hideHungerBar() || drawHudContext.getHasMountHealth())) {
            x = drawHudContext.getMirroredX(x);
        }
        original.call(new Object[]{drawContext, texture, x, drawHudContext.getBubblesBarY(), width, height});
    }

    static {
        VANILLA_ARMOR_EMPTY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"melancholic_hunger", (String)"hud/armor_empty");
        VANILLA_ARMOR_HALF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"melancholic_hunger", (String)"hud/armor_half");
        VANILLA_ARMOR_HALF_TEXTURE_INVERSED = ResourceLocation.fromNamespaceAndPath((String)"melancholic_hunger", (String)"hud/armor_half_inversed");
    }
}

