/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.nostalgic_tweaks.mixin;

import antigers.melancholic_hunger.config.ClientConfigData;
import antigers.melancholic_hunger.config.HungerEffectOption;
import antigers.melancholic_hunger.config.ServerConfigData;
import antigers.melancholic_hunger.config.SprintingOption;
import antigers.melancholic_hunger.config.YACLConfig;
import antigers.melancholic_hunger.nostalgic_tweaks.NostalgicTweaksConfigHandlerWriter;
import antigers.melancholic_hunger.utils.ClientOnlyHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import mod.adrenix.nostalgic.config.ClientConfig;
import mod.adrenix.nostalgic.config.ServerConfig;
import mod.adrenix.nostalgic.config.factory.ConfigHandler;
import mod.adrenix.nostalgic.config.factory.ConfigMeta;
import mod.adrenix.nostalgic.tweak.listing.ItemMap;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ConfigHandler.class})
public abstract class ConfigHandlerMixin<T extends ConfigMeta>
implements NostalgicTweaksConfigHandlerWriter {
    @Shadow(remap=false)
    @Nullable
    private T loaded;
    @Shadow(remap=false)
    @Final
    private Runnable onLoad;

    @Shadow(remap=false)
    public abstract boolean load();

    @Shadow(remap=false)
    public abstract void save();

    @Unique
    void setGameplayConfigFromNT(boolean disableHunger, boolean preventHungerEffect, boolean disableSprint, boolean oldFoodStacking, ItemMap<Integer> customFoodStacking, boolean instantEat) {
        ServerConfigData.ImmutableServerConfigData currentServerData = YACLConfig.getServerData();
        ServerConfigData serverData = new ServerConfigData();
        serverData.disableHunger = disableHunger;
        serverData.instantEating = instantEat;
        serverData.hungerEffect = preventHungerEffect ? HungerEffectOption.DISABLED : (currentServerData.hungerEffect() != HungerEffectOption.DISABLED ? currentServerData.hungerEffect() : (disableHunger ? HungerEffectOption.REPLACED_WITH_POISON : HungerEffectOption.VANILLA));
        serverData.sprinting = disableSprint ? SprintingOption.DISABLED : (currentServerData.sprinting() != SprintingOption.DISABLED ? currentServerData.sprinting() : (disableHunger ? SprintingOption.LIMITED_BY_HEALTH : SprintingOption.VANILLA));
        serverData.useCustomFoodStackSizes = oldFoodStacking;
        if (oldFoodStacking) {
            LinkedHashMap<String, Integer> customFoodStackSizesHashMap = new LinkedHashMap<String, Integer>();
            for (Map.Entry entry : customFoodStacking.entrySet()) {
                customFoodStackSizesHashMap.put((String)entry.getKey(), (Integer)entry.getValue());
            }
            serverData.customFoodStackSizes = customFoodStackSizesHashMap;
        }
        YACLConfig.setServerData(serverData.getImmutable());
        YACLConfig.saveToDisk();
    }

    @Unique
    void setConfigFromNT() {
        T t = this.loaded;
        if (t instanceof ClientConfig) {
            ClientConfig clientConfig = (ClientConfig)t;
            if (ClientOnlyHelper.isInSingleplayer() || ClientOnlyHelper.hasSingleplayerServer() || ClientOnlyHelper.getLocalPlayer() == null) {
                gameplayConfig = clientConfig.gameplay;
                this.setGameplayConfigFromNT(gameplayConfig.disableHunger, gameplayConfig.preventHungerEffect, gameplayConfig.disableSprint, gameplayConfig.oldFoodStacking, (ItemMap<Integer>)gameplayConfig.customFoodStacking, gameplayConfig.instantEat);
            }
            clientData = new ClientConfigData();
            ((ClientConfigData)clientData).hideHungerBar = clientConfig.eyeCandy.hideHungerBar;
            ((ClientConfigData)clientData).hideExperienceBar = clientConfig.eyeCandy.hideExperienceBar;
            YACLConfig.setClientData(((ClientConfigData)clientData).getImmutable());
        } else {
            clientData = this.loaded;
            if (clientData instanceof ServerConfig) {
                ServerConfig serverConfig = (ServerConfig)clientData;
                gameplayConfig = serverConfig.gameplay;
                this.setGameplayConfigFromNT(gameplayConfig.disableHunger, gameplayConfig.preventHungerEffect, gameplayConfig.disableSprint, gameplayConfig.oldFoodStacking, (ItemMap<Integer>)gameplayConfig.customFoodStacking, gameplayConfig.instantEat);
            }
        }
    }

    @Override
    public void melancholic_hunger$writeConfigToNT(ServerConfigData.ImmutableServerConfigData serverData, @Nullable ClientConfigData.ImmutableClientConfigData clientData) {
        if (this.loaded == null) {
            this.load();
        }
        boolean disableHunger = serverData.disableHunger();
        boolean instantEat = serverData.instantEating();
        boolean preventHungerEffect = serverData.hungerEffect() == HungerEffectOption.DISABLED;
        boolean disableSprint = serverData.sprinting() == SprintingOption.DISABLED;
        boolean useCustomFoodStackSizes = serverData.useCustomFoodStackSizes();
        ItemMap customFoodStacking = new ItemMap((Object)1).startWith(serverData.customFoodStackSizes());
        T t = this.loaded;
        if (t instanceof ClientConfig) {
            ClientConfig clientConfig = (ClientConfig)t;
            if (ClientOnlyHelper.isInSingleplayer() || ClientOnlyHelper.hasSingleplayerServer() || ClientOnlyHelper.getLocalPlayer() == null) {
                gameplayConfig = clientConfig.gameplay;
                ((ClientConfig.Gameplay)gameplayConfig).disableHunger = disableHunger;
                ((ClientConfig.Gameplay)gameplayConfig).preventHungerEffect = preventHungerEffect;
                ((ClientConfig.Gameplay)gameplayConfig).instantEat = instantEat;
                ((ClientConfig.Gameplay)gameplayConfig).disableSprint = disableSprint;
                ((ClientConfig.Gameplay)gameplayConfig).oldFoodStacking = useCustomFoodStackSizes;
                ((ClientConfig.Gameplay)gameplayConfig).customFoodStacking = customFoodStacking;
            }
            if (clientData != null) {
                clientConfig.eyeCandy.hideHungerBar = clientData.hideHungerBar();
                clientConfig.eyeCandy.hideExperienceBar = clientData.hideExperienceBar();
            }
        } else {
            gameplayConfig = this.loaded;
            if (gameplayConfig instanceof ServerConfig) {
                ServerConfig serverConfig = (ServerConfig)gameplayConfig;
                gameplayConfig = serverConfig.gameplay;
                ((ServerConfig.Gameplay)gameplayConfig).disableHunger = disableHunger;
                ((ServerConfig.Gameplay)gameplayConfig).preventHungerEffect = preventHungerEffect;
                ((ServerConfig.Gameplay)gameplayConfig).instantEat = instantEat;
                ((ServerConfig.Gameplay)gameplayConfig).disableSprint = disableSprint;
                ((ServerConfig.Gameplay)gameplayConfig).oldFoodStacking = useCustomFoodStackSizes;
                ((ServerConfig.Gameplay)gameplayConfig).customFoodStacking = customFoodStacking;
            }
        }
        this.save();
        this.onLoad.run();
    }

    @Inject(method={"save"}, at={@At(value="RETURN")}, remap=false)
    void save_nostalgic_tweaks_config(CallbackInfo ci) {
        this.setConfigFromNT();
    }
}

