/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.hud;

import antigers.melancholic_hunger.config.YACLConfig;
import net.minecraft.class_156;

public class ExperienceBarAnimation {
    private static final int ANIMATION_TIME = 150;
    private long startTime;
    private boolean isRunning = false;
    private boolean reverse = true;
    private int currentPos = 0;
    private float currentOpacity = 0.0f;
    private long drawUntil = 0L;

    private void beginIfNotAlready(long now) {
        if (this.currentPos > 0 || this.isRunning) {
            return;
        }
        this.startTime = now;
        this.reverse = false;
        this.isRunning = true;
    }

    private void beginReverseIfNotAlready(long now) {
        if (this.currentPos < 7 || this.isRunning) {
            return;
        }
        this.startTime = now;
        this.reverse = true;
        this.isRunning = true;
    }

    public void onGainExperience() {
        long now = class_156.method_658();
        this.drawUntil = now + 3000L;
        this.beginIfNotAlready(now);
    }

    public void update(boolean isExpBarDrawnConstantly) {
        if (!YACLConfig.hideExperienceBar()) {
            this.currentPos = 7;
            this.currentOpacity = 1.0f;
            return;
        }
        long now = class_156.method_658();
        if (isExpBarDrawnConstantly) {
            this.drawUntil = 0L;
            this.beginIfNotAlready(now);
        } else if (now > this.drawUntil) {
            this.drawUntil = 0L;
            this.beginReverseIfNotAlready(now);
        }
        if (!this.isRunning) {
            return;
        }
        if (YACLConfig.enableExperienceAnimation()) {
            long animationTime = now - this.startTime;
            if (animationTime < 150L) {
                this.currentOpacity = (float)animationTime / 150.0f;
                this.currentPos = (int)(this.currentOpacity * 7.0f);
            } else {
                this.currentOpacity = 1.0f;
                this.currentPos = 7;
                this.isRunning = false;
            }
        } else {
            this.currentOpacity = 1.0f;
            this.currentPos = 7;
            this.isRunning = false;
        }
        if (this.reverse) {
            this.currentOpacity = 1.0f - this.currentOpacity;
            this.currentPos = 7 - this.currentPos;
        }
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public float getCurrentOpacity() {
        return this.currentOpacity;
    }

    public boolean shouldDraw() {
        return this.drawUntil > 0L || this.currentPos > 0;
    }
}

