/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.config;

import antigers.melancholic_hunger.MelancholicHunger;
import antigers.melancholic_hunger.components.ServerConfigComponent;
import antigers.melancholic_hunger.config.ClientConfigData;
import antigers.melancholic_hunger.config.ConfigOption;
import antigers.melancholic_hunger.config.HungerEffectOption;
import antigers.melancholic_hunger.config.ItemIntegerMapConfigOption;
import antigers.melancholic_hunger.config.ServerConfigData;
import antigers.melancholic_hunger.config.SprintingOption;
import antigers.melancholic_hunger.nostalgic_tweaks.NostalgicTweaksConfigHandlerWriter;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.lang.model.type.NullType;
import mod.adrenix.nostalgic.config.factory.ConfigBuilder;
import mod.adrenix.nostalgic.tweak.config.GameplayTweak;
import mod.adrenix.nostalgic.tweak.listing.ItemMap;
import mod.adrenix.nostalgic.tweak.listing.ItemSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;

public class YACLConfig {
    private static final String CONFIG_PREFIX = "screen.melancholic_hunger.config.";
    @SerialEntry(value="clientOptions")
    private static ClientConfigData clientData = new ClientConfigData();
    @SerialEntry(value="serverOptions")
    private static ServerConfigData serverData = new ServerConfigData();
    private static final ConfigClassHandler<YACLConfig> HANDLER = ConfigClassHandler.createBuilder(YACLConfig.class).id(ResourceLocation.fromNamespaceAndPath((String)"melancholic_hunger", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FMLPaths.CONFIGDIR.get().resolve("melancholic_hunger.json5")).setJson5(true).build()).build();
    private static final ConfigOption<Boolean, NullType> DISABLE_HUNGER = new ConfigOption("disableHunger", true, true, true, () -> YACLConfig.serverData.disableHunger, val -> {
        YACLConfig.serverData.disableHunger = val;
    });
    private static final ConfigOption<Boolean, Boolean> HIDE_HUNGER_BAR = new ConfigOption<Boolean, Boolean>("hideHungerBar", true, true, false, () -> YACLConfig.clientData.hideHungerBar, val -> {
        YACLConfig.clientData.hideHungerBar = val;
    }).addValueDependency(DISABLE_HUNGER, false, false, true);
    private static final ConfigOption<HungerEffectOption, Boolean> HUNGER_EFFECT = new ConfigOption<HungerEffectOption, Boolean>("hungerEffect", HungerEffectOption.REPLACED_WITH_POISON, true, true, () -> YACLConfig.serverData.hungerEffect, val -> {
        YACLConfig.serverData.hungerEffect = val;
    }).addValueDependency(DISABLE_HUNGER, true, HungerEffectOption.REPLACED_WITH_POISON, HungerEffectOption.VANILLA);
    private static final ConfigOption<Boolean, Boolean> HIGHLIGHT_RESTORED_HEARTS = new ConfigOption<Boolean, Boolean>("highlightRestoredHearts", true, false, false, () -> YACLConfig.clientData.highlightRestoredHearts, val -> {
        YACLConfig.clientData.highlightRestoredHearts = val;
    }).addValueDependency(DISABLE_HUNGER, true, true, false);
    private static final ConfigOption<Boolean, Boolean> GRADUAL_HEALTH_REGENERATION = new ConfigOption<Boolean, Boolean>("gradualHealthRegeneration", true, false, true, () -> YACLConfig.serverData.gradualHealthRegeneration, val -> {
        YACLConfig.serverData.gradualHealthRegeneration = val;
    }).addValueDependency(DISABLE_HUNGER, true, true, false);
    private static final ConfigOption<Float, Boolean> GRADUAL_HEALTH_REGENERATION_SPEED = new ConfigOption<Float, Boolean>("gradualHealthRegenerationSpeed", Float.valueOf(1.0f), false, true, () -> YACLConfig.serverData.gradualHealthRegenerationSpeed, val -> {
        YACLConfig.serverData.gradualHealthRegenerationSpeed = val;
    }).addDependency(GRADUAL_HEALTH_REGENERATION, true);
    private static final ConfigOption<Boolean, Boolean> HIGHLIGHT_REGENERATED_HEARTS = new ConfigOption<Boolean, Boolean>("highlightRegeneratedHearts", true, false, false, () -> YACLConfig.clientData.highlightRegeneratedHearts, val -> {
        YACLConfig.clientData.highlightRegeneratedHearts = val;
    }).addValueDependency(GRADUAL_HEALTH_REGENERATION, true, true, false);
    private static final ConfigOption<Boolean, Boolean> INSTANT_EATING = new ConfigOption("instantEating", false, true, true, () -> YACLConfig.serverData.instantEating, val -> {
        YACLConfig.serverData.instantEating = val;
    });
    private static final ConfigOption<Boolean, Boolean> SHOW_FOOD_ITEM_TOOLTIPS = new ConfigOption<Boolean, Boolean>("showFoodItemTooltips", true, false, true, () -> YACLConfig.serverData.showFoodItemTooltips, val -> {
        YACLConfig.serverData.showFoodItemTooltips = val;
    }).addValueDependency(DISABLE_HUNGER, true, true, false);
    private static final ConfigOption<SprintingOption, NullType> SPRINTING = new ConfigOption("sprinting", SprintingOption.LIMITED_BY_HEALTH, true, true, () -> YACLConfig.serverData.sprinting, val -> {
        YACLConfig.serverData.sprinting = val;
    });
    private static final ConfigOption<Integer, SprintingOption> SPRINTING_HEALTH_LIMIT = new ConfigOption<Integer, SprintingOption>("sprintingHealthLimit", 6, false, true, () -> YACLConfig.serverData.sprintingHealthLimit, val -> {
        YACLConfig.serverData.sprintingHealthLimit = val;
    }).addDependency(SPRINTING, SprintingOption.LIMITED_BY_HEALTH);
    private static final ConfigOption<Boolean, Boolean> USE_CUSTOM_FOOD_STACK_SIZES = new ConfigOption("useCustomFoodStackSizes", true, true, true, () -> YACLConfig.serverData.useCustomFoodStackSizes, val -> {
        YACLConfig.serverData.useCustomFoodStackSizes = val;
    });
    private static final ItemIntegerMapConfigOption CUSTOM_FOOD_STACK_SIZES = (ItemIntegerMapConfigOption)new ItemIntegerMapConfigOption("customFoodStackSizes", YACLConfig.getDefaultItemStackSizes(), true, true, () -> YACLConfig.serverData.customFoodStackSizes, val -> {
        YACLConfig.serverData.customFoodStackSizes = val;
    }).addDependency(USE_CUSTOM_FOOD_STACK_SIZES, (Object)true);
    private static final ConfigOption<Boolean, NullType> HIDE_EXPERIENCE_BAR = new ConfigOption("hideExperienceBar", true, true, false, () -> YACLConfig.clientData.hideExperienceBar, val -> {
        YACLConfig.clientData.hideExperienceBar = val;
    });
    private static final ConfigOption<Boolean, Boolean> SHOW_EXPERIENCE_IN_INVENTORY = new ConfigOption<Boolean, Boolean>("showExperienceInInventory", true, false, false, () -> YACLConfig.clientData.showExperienceInInventory, val -> {
        YACLConfig.clientData.showExperienceInInventory = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> SHOW_EXPERIENCE_ON_SCREENS = new ConfigOption<Boolean, Boolean>("showExperienceOnScreens", true, false, false, () -> YACLConfig.clientData.showExperienceOnScreens, val -> {
        YACLConfig.clientData.showExperienceOnScreens = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> SHOW_EXPERIENCE_ON_GAIN = new ConfigOption<Boolean, Boolean>("showExperienceOnGain", true, false, false, () -> YACLConfig.clientData.showExperienceOnGain, val -> {
        YACLConfig.clientData.showExperienceOnGain = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> ENABLE_EXPERIENCE_ANIMATION = new ConfigOption<Boolean, Boolean>("enableExperienceAnimation", true, false, false, () -> YACLConfig.clientData.enableExperienceAnimation, val -> {
        YACLConfig.clientData.enableExperienceAnimation = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> RENDER_EXPERIENCE_OVER_BACKGROUND = new ConfigOption<Boolean, Boolean>("renderExperienceOverBackground", true, false, false, () -> YACLConfig.clientData.renderExperienceOverBackground, val -> {
        YACLConfig.clientData.renderExperienceOverBackground = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final List<ConfigOption<?, ?>> ALL_OPTIONS = List.of(DISABLE_HUNGER, GRADUAL_HEALTH_REGENERATION, GRADUAL_HEALTH_REGENERATION_SPEED, HIDE_HUNGER_BAR, HUNGER_EFFECT, HIGHLIGHT_REGENERATED_HEARTS, INSTANT_EATING, SHOW_FOOD_ITEM_TOOLTIPS, USE_CUSTOM_FOOD_STACK_SIZES, CUSTOM_FOOD_STACK_SIZES, SPRINTING, SPRINTING_HEALTH_LIMIT, HIGHLIGHT_RESTORED_HEARTS, HIDE_EXPERIENCE_BAR, SHOW_EXPERIENCE_IN_INVENTORY, SHOW_EXPERIENCE_ON_SCREENS, SHOW_EXPERIENCE_ON_GAIN, ENABLE_EXPERIENCE_ANIMATION, RENDER_EXPERIENCE_OVER_BACKGROUND);

    public static int getFoodHealth(ItemStack itemStack, FoodProperties foodComponent) {
        if (MelancholicHunger.nostalgicTweaksInstalled && ((ItemMap)GameplayTweak.CUSTOM_FOOD_HEALTH.get()).containsItem(itemStack)) {
            return (Integer)((ItemMap)GameplayTweak.CUSTOM_FOOD_HEALTH.get()).valueFrom(itemStack);
        }
        return foodComponent.nutrition();
    }

    private static LinkedHashMap<String, Integer> getDefaultItemStackSizes() {
        LinkedHashMap<Item, Integer> sizes = new LinkedHashMap<Item, Integer>();
        sizes.put(Items.BEETROOT, 64);
        sizes.put(Items.DRIED_KELP, 64);
        sizes.put(Items.COOKIE, 32);
        sizes.put(Items.GLOW_BERRIES, 32);
        sizes.put(Items.MELON_SLICE, 32);
        sizes.put(Items.SWEET_BERRIES, 32);
        sizes.put(Items.APPLE, 16);
        sizes.put(Items.ENCHANTED_GOLDEN_APPLE, 16);
        sizes.put(Items.GOLDEN_APPLE, 16);
        sizes.put(Items.POTATO, 16);
        sizes.put(Items.BAKED_POTATO, 16);
        sizes.put(Items.POISONOUS_POTATO, 16);
        sizes.put(Items.CARROT, 16);
        sizes.put(Items.GOLDEN_CARROT, 16);
        sizes.put(Items.CHORUS_FRUIT, 16);
        sizes.put(Items.BREAD, 8);
        sizes.put(Items.COD, 8);
        sizes.put(Items.COOKED_COD, 8);
        sizes.put(Items.SALMON, 8);
        sizes.put(Items.COOKED_SALMON, 8);
        sizes.put(Items.PUFFERFISH, 8);
        sizes.put(Items.TROPICAL_FISH, 8);
        sizes.put(Items.CHICKEN, 8);
        sizes.put(Items.COOKED_CHICKEN, 8);
        sizes.put(Items.MUTTON, 8);
        sizes.put(Items.COOKED_MUTTON, 8);
        sizes.put(Items.RABBIT, 8);
        sizes.put(Items.COOKED_RABBIT, 8);
        sizes.put(Items.HONEY_BOTTLE, 8);
        sizes.put(Items.BEEF, 4);
        sizes.put(Items.COOKED_BEEF, 4);
        sizes.put(Items.PORKCHOP, 4);
        sizes.put(Items.COOKED_PORKCHOP, 4);
        sizes.put(Items.PUMPKIN_PIE, 4);
        sizes.put(Items.BEETROOT_SOUP, 1);
        sizes.put(Items.MUSHROOM_STEW, 1);
        sizes.put(Items.RABBIT_STEW, 1);
        sizes.put(Items.SUSPICIOUS_STEW, 1);
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : sizes.entrySet()) {
            result.put(BuiltInRegistries.ITEM.getKey((Object)((Item)entry.getKey())).toString(), (Integer)entry.getValue());
        }
        return result;
    }

    private static BooleanControllerBuilder createBooleanController(Option<Boolean> option) {
        return BooleanControllerBuilder.create(option).yesNoFormatter().coloured(true);
    }

    private static ConfigCategory buildHungerCategory() {
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((Component)Component.translatable((String)"screen.melancholic_hunger.config.hunger_category_name")).tooltip(new Component[]{Component.translatable((String)"screen.melancholic_hunger.config.hunger_category_tooltip")}).option(DISABLE_HUNGER.buildYACLOption(YACLConfig::createBooleanController));
        if (MelancholicHunger.nostalgicTweaksInstalled) {
            builder.option(HIDE_HUNGER_BAR.buildYACLOption(YACLConfig::createBooleanController));
        }
        builder.option(HUNGER_EFFECT.buildYACLOption(option -> EnumControllerBuilder.create((Option)option).enumClass(HungerEffectOption.class).formatValue(value -> switch (value) {
            default -> throw new MatchException(null, null);
            case HungerEffectOption.VANILLA -> Component.translatable((String)"screen.melancholic_hunger.config.hunger_effect_vanilla_option").setStyle(Style.EMPTY.withColor(0x55FF55));
            case HungerEffectOption.DISABLED -> Component.translatable((String)"screen.melancholic_hunger.config.hunger_effect_disabled_option").setStyle(Style.EMPTY.withColor(0xFF5555));
            case HungerEffectOption.REPLACED_WITH_POISON -> Component.translatable((String)"screen.melancholic_hunger.config.hunger_effect_replaced_with_poison_option").setStyle(Style.EMPTY.withColor(0xFFFF55));
        }))).option(HIGHLIGHT_RESTORED_HEARTS.buildYACLOption(YACLConfig::createBooleanController)).option(GRADUAL_HEALTH_REGENERATION.buildYACLOption(YACLConfig::createBooleanController)).option(GRADUAL_HEALTH_REGENERATION_SPEED.buildYACLOption(option -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(10.0f))).step((Number)Float.valueOf(0.1f)))).option(HIGHLIGHT_REGENERATED_HEARTS.buildYACLOption(YACLConfig::createBooleanController)).option(INSTANT_EATING.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_FOOD_ITEM_TOOLTIPS.buildYACLOption(YACLConfig::createBooleanController));
        return builder.build();
    }

    private static void setAllFoodStacksTo1(YACLScreen screen, ButtonOption button) {
        LinkedHashMap<String, Integer> stacks = YACLConfig.getDefaultItemStackSizes();
        stacks.replaceAll((k, v) -> 1);
        stacks.replace(Items.COOKIE.toString(), 8);
        stacks.replace(Items.BEETROOT.toString(), 8);
        stacks.replace(Items.CARROT.toString(), 8);
        stacks.replace(Items.CHORUS_FRUIT.toString(), 8);
        stacks.replace(Items.MELON_SLICE.toString(), 8);
        stacks.replace(Items.POTATO.toString(), 8);
        stacks.replace(Items.POISONOUS_POTATO.toString(), 8);
        stacks.replace(Items.SWEET_BERRIES.toString(), 8);
        stacks.replace(Items.GLOW_BERRIES.toString(), 8);
        stacks.replace(Items.DRIED_KELP.toString(), 9);
        stacks.replace(Items.HONEY_BOTTLE.toString(), 4);
        CUSTOM_FOOD_STACK_SIZES.updatePendingValue(stacks);
    }

    private static void setAllFoodStacksTo64(YACLScreen screen, ButtonOption button) {
        LinkedHashMap<String, Integer> stacks = YACLConfig.getDefaultItemStackSizes();
        stacks.replaceAll((k, v) -> 64);
        CUSTOM_FOOD_STACK_SIZES.updatePendingValue(stacks);
    }

    private static ButtonOption createButtonOption(String buttonName, BiConsumer<YACLScreen, ButtonOption> action, ConfigOption.ConfigOptionDependency<?> dependency) {
        boolean playerHasPermission = ConfigOption.getPlayerHasPermission();
        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
        descriptionBuilder.text(new Component[]{Component.translatable((String)("screen.melancholic_hunger.config.button." + buttonName + ".description"))});
        if (!playerHasPermission) {
            descriptionBuilder.text(new Component[]{Component.literal((String)"\n"), Component.translatable((String)"screen.melancholic_hunger.config.op_privileges_required_option").setStyle(Style.EMPTY.withColor(0xFF5555).withItalic(Boolean.valueOf(true)))});
        }
        ButtonOption buttonOption = ButtonOption.createBuilder().name((Component)Component.translatable((String)("screen.melancholic_hunger.config.button." + buttonName + ".name"))).available(ConfigOption.getPlayerHasPermission()).description(descriptionBuilder.build()).text((Component)Component.empty()).action(action).build();
        dependency.configOption().YACLOption.addEventListener((option, event) -> {
            if (event != OptionEventListener.Event.STATE_CHANGE) {
                return;
            }
            buttonOption.setAvailable(dependency.isPendingValueEqualsRequired());
        });
        return buttonOption;
    }

    private static ConfigCategory buildFoodItemsCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"screen.melancholic_hunger.config.food_category_name")).tooltip(new Component[]{Component.translatable((String)"screen.melancholic_hunger.config.food_category_tooltip")}).option(USE_CUSTOM_FOOD_STACK_SIZES.buildYACLOption(YACLConfig::createBooleanController)).option(CUSTOM_FOOD_STACK_SIZES.buildYACLOption()).option((Option)YACLConfig.createButtonOption("set_all_food_stack_sizes_to_1", YACLConfig::setAllFoodStacksTo1, new ConfigOption.ConfigOptionDependency<Boolean>(USE_CUSTOM_FOOD_STACK_SIZES, true))).option((Option)YACLConfig.createButtonOption("set_all_food_stack_sizes_to_64", YACLConfig::setAllFoodStacksTo64, new ConfigOption.ConfigOptionDependency<Boolean>(USE_CUSTOM_FOOD_STACK_SIZES, true))).build();
    }

    private static ConfigCategory buildSprintingCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"screen.melancholic_hunger.config.sprinting_category_name")).tooltip(new Component[]{Component.translatable((String)"screen.melancholic_hunger.config.sprinting_category_tooltip")}).option(SPRINTING.buildYACLOption(option -> EnumControllerBuilder.create((Option)option).enumClass(SprintingOption.class).formatValue(value -> switch (value) {
            default -> throw new MatchException(null, null);
            case SprintingOption.VANILLA -> Component.translatable((String)"screen.melancholic_hunger.config.sprinting_vanilla_option").setStyle(Style.EMPTY.withColor(0x55FF55));
            case SprintingOption.DISABLED -> Component.translatable((String)"screen.melancholic_hunger.config.sprinting_disabled_option").setStyle(Style.EMPTY.withColor(0xFF5555));
            case SprintingOption.LIMITED_BY_HEALTH -> Component.translatable((String)"screen.melancholic_hunger.config.sprinting_limited_by_health_option").setStyle(Style.EMPTY.withColor(0xFFFF55));
        }))).option(SPRINTING_HEALTH_LIMIT.buildYACLOption(option -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)1, (Number)20)).step((Number)1))).build();
    }

    private static ConfigCategory buildExperienceCategory() {
        return ConfigCategory.createBuilder().name((Component)Component.translatable((String)"screen.melancholic_hunger.config.experience_category_name")).tooltip(new Component[]{Component.translatable((String)"screen.melancholic_hunger.config.experience_category_tooltip")}).option(HIDE_EXPERIENCE_BAR.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_EXPERIENCE_IN_INVENTORY.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_EXPERIENCE_ON_SCREENS.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_EXPERIENCE_ON_GAIN.buildYACLOption(YACLConfig::createBooleanController)).option(ENABLE_EXPERIENCE_ANIMATION.buildYACLOption(YACLConfig::createBooleanController)).option(RENDER_EXPERIENCE_OVER_BACKGROUND.buildYACLOption(YACLConfig::createBooleanController)).build();
    }

    public static YetAnotherConfigLib getYACLInstance() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> builder.title((Component)Component.translatable((String)"screen.melancholic_hunger.config.title")).category(YACLConfig.buildHungerCategory()).category(YACLConfig.buildFoodItemsCategory()).category(YACLConfig.buildSprintingCategory()).category(YACLConfig.buildExperienceCategory()).save(() -> {
            Minecraft client = Minecraft.getInstance();
            boolean isSinglePlayer = client.isSingleplayer();
            boolean hasSingleplayerServer = client.hasSingleplayerServer();
            LocalPlayer player = client.player;
            if (!MelancholicHunger.nostalgicTweaksInstalled) {
                YACLConfig.clientData.hideHungerBar = YACLConfig.serverData.disableHunger;
            }
            if (isSinglePlayer || player == null || hasSingleplayerServer) {
                HANDLER.save();
                if (hasSingleplayerServer) {
                    ServerConfigComponent.syncAllPlayersExceptOf(player.getId());
                }
            } else {
                ServerConfigComponent.sendToServer(serverData.getImmutable());
            }
            if (MelancholicHunger.nostalgicTweaksInstalled) {
                NostalgicTweaksConfigHandlerWriter handler = (NostalgicTweaksConfigHandlerWriter)ConfigBuilder.getHandler();
                handler.melancholic_hunger$writeConfigToNT(serverData.getImmutable(), clientData.getImmutable());
                if (hasSingleplayerServer) {
                    ServerConfigComponent.syncNostalgicTweaksToAllPlayers();
                }
            }
        }));
    }

    private static void updateCurrentScreen() {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        if (Minecraft.getInstance().screen instanceof YACLScreen) {
            ALL_OPTIONS.forEach(ConfigOption::forgetPendingValueIfServerOption);
        }
    }

    public static void loadFromDisk() {
        HANDLER.load();
        for (ConfigOption<?, ?> option : ALL_OPTIONS) {
            option.validateValue();
        }
        if (!MelancholicHunger.nostalgicTweaksInstalled) {
            HIDE_HUNGER_BAR.setValue(false);
        }
    }

    public static void saveToDisk() {
        HANDLER.save();
    }

    public static ClientConfigData.ImmutableClientConfigData getClientData() {
        return clientData.getImmutable();
    }

    public static void setClientData(ClientConfigData.ImmutableClientConfigData newClientData) {
        HIDE_HUNGER_BAR.setValue(newClientData.hideHungerBar());
        HIGHLIGHT_REGENERATED_HEARTS.setValue(newClientData.highlightRegeneratedHearts());
        HIGHLIGHT_RESTORED_HEARTS.setValue(newClientData.highlightRestoredHearts());
        HIDE_EXPERIENCE_BAR.setValue(newClientData.hideExperienceBar());
        SHOW_EXPERIENCE_IN_INVENTORY.setValue(newClientData.showExperienceInInventory());
        SHOW_EXPERIENCE_ON_SCREENS.setValue(newClientData.showExperienceOnScreens());
        SHOW_EXPERIENCE_ON_GAIN.setValue(newClientData.showExperienceOnScreens());
        ENABLE_EXPERIENCE_ANIMATION.setValue(newClientData.enableExperienceAnimation());
        RENDER_EXPERIENCE_OVER_BACKGROUND.setValue(newClientData.renderExperienceOverBackground());
    }

    public static ServerConfigData.ImmutableServerConfigData getServerData() {
        return serverData.getImmutable();
    }

    public static boolean setServerData(ServerConfigData.ImmutableServerConfigData newServerData) {
        if (serverData.getImmutable().equals(newServerData)) {
            return false;
        }
        DISABLE_HUNGER.setValue(newServerData.disableHunger());
        if (!MelancholicHunger.nostalgicTweaksInstalled) {
            HIDE_HUNGER_BAR.setValue(false);
        }
        HUNGER_EFFECT.setValue(newServerData.hungerEffect());
        GRADUAL_HEALTH_REGENERATION.setValue(newServerData.gradualHealthRegeneration());
        GRADUAL_HEALTH_REGENERATION_SPEED.setValue(newServerData.gradualHealthRegenerationSpeed());
        INSTANT_EATING.setValue(newServerData.instantEating());
        SHOW_FOOD_ITEM_TOOLTIPS.setValue(newServerData.showFoodItemTooltips());
        USE_CUSTOM_FOOD_STACK_SIZES.setValue(newServerData.useCustomFoodStackSizes());
        CUSTOM_FOOD_STACK_SIZES.setValue(newServerData.customFoodStackSizes());
        SPRINTING.setValue(newServerData.sprinting());
        SPRINTING_HEALTH_LIMIT.setValue(newServerData.sprintingHealthLimit());
        YACLConfig.updateCurrentScreen();
        return true;
    }

    public static boolean disableHunger() {
        return YACLConfig.serverData.disableHunger;
    }

    public static boolean hideHungerBar() {
        return YACLConfig.clientData.hideHungerBar;
    }

    public static boolean highlightRegeneratedHearts() {
        return YACLConfig.clientData.highlightRegeneratedHearts;
    }

    public static boolean highlightRestoredHearts() {
        return YACLConfig.clientData.highlightRestoredHearts;
    }

    public static HungerEffectOption hungerEffect() {
        return YACLConfig.serverData.hungerEffect;
    }

    public static boolean gradualHealthRegeneration() {
        return YACLConfig.serverData.gradualHealthRegeneration;
    }

    public static float gradualHealthRegenerationSpeed() {
        return YACLConfig.serverData.gradualHealthRegenerationSpeed.floatValue();
    }

    public static boolean shouldInstantlyEat(Item item) {
        if (!YACLConfig.serverData.instantEating.booleanValue()) {
            return false;
        }
        if (MelancholicHunger.nostalgicTweaksInstalled) {
            return !((ItemSet)GameplayTweak.IGNORED_EDIBLES.get()).containsItem(item);
        }
        return true;
    }

    public static boolean showFoodItemTooltips() {
        return YACLConfig.serverData.showFoodItemTooltips;
    }

    public static Integer getItemStackSize(ItemStack itemStack) {
        String itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString();
        if (YACLConfig.serverData.useCustomFoodStackSizes.booleanValue() && YACLConfig.serverData.customFoodStackSizes.containsKey(itemId)) {
            return YACLConfig.serverData.customFoodStackSizes.get(itemId);
        }
        return null;
    }

    public static SprintingOption sprinting() {
        return YACLConfig.serverData.sprinting;
    }

    public static int sprintingHealthLimit() {
        return YACLConfig.serverData.sprintingHealthLimit;
    }

    public static boolean hideExperienceBar() {
        return YACLConfig.clientData.hideExperienceBar;
    }

    public static boolean showExperienceInInventory() {
        return YACLConfig.clientData.showExperienceInInventory;
    }

    public static boolean showExperienceOnScreens() {
        return YACLConfig.clientData.showExperienceOnScreens;
    }

    public static boolean showExperienceOnGain() {
        return YACLConfig.clientData.showExperienceOnGain;
    }

    public static boolean enableExperienceAnimation() {
        return YACLConfig.clientData.enableExperienceAnimation;
    }

    public static boolean renderExperienceOverBackground() {
        return YACLConfig.clientData.renderExperienceOverBackground;
    }
}

