/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger;

import antigers.melancholic_hunger.Cake;
import antigers.melancholic_hunger.config.YACLConfig;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import net.minecraft.class_9334;

public class FoodItemTooltips {
    private static final String CONFIG_PREFIX = "gui.melancholic_hunger.regeneration_tooltip.";

    private static void appendTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 tooltipType, List<class_2561> lines) {
        class_124 formatting;
        String regenerationRate;
        class_4174 foodProperties = (class_4174)stack.method_58694(class_9334.field_50075);
        if (foodProperties == null) {
            if (stack.method_7909() != class_1802.field_17534) {
                return;
            }
            foodProperties = Cake.FOOD_PROPERTIES;
        }
        if (!YACLConfig.showFoodItemTooltips()) {
            return;
        }
        int foodNutrition = YACLConfig.getFoodHealth(stack, foodProperties);
        if (foodNutrition <= 0) {
            return;
        }
        lines.add(new FoodHealthTextComponent(foodNutrition));
        if (!YACLConfig.gradualHealthRegeneration()) {
            return;
        }
        float regenerationRatio = (float)foodNutrition / foodProperties.comp_2492();
        if (regenerationRatio <= 0.5f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.super_fast";
            formatting = class_124.field_1064;
        } else if (regenerationRatio <= 0.8f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.very_fast";
            formatting = class_124.field_1077;
        } else if (regenerationRatio <= 1.6f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.fast";
            formatting = class_124.field_1060;
        } else if (regenerationRatio <= 2.5f) {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.slow";
            formatting = class_124.field_1061;
        } else {
            regenerationRate = "gui.melancholic_hunger.regeneration_tooltip.very_slow";
            formatting = class_124.field_1079;
        }
        lines.add((class_2561)class_2561.method_43469((String)"gui.melancholic_hunger.regeneration_tooltip.template", (Object[])new Object[]{class_2561.method_43471((String)regenerationRate)}).method_10862(class_2583.field_24360.method_36139(formatting.method_532().intValue())));
    }

    public static void register() {
        ItemTooltipCallback.EVENT.register(FoodItemTooltips::appendTooltip);
    }

    public record FoodHealthTextComponent(int foodNutrition) implements class_2561,
    class_5481
    {
        static List<class_2561> emptySiblings = new ArrayList<class_2561>();

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_7417 method_10851() {
            return class_8828.field_46625;
        }

        public List<class_2561> method_10855() {
            return emptySiblings;
        }

        public class_5481 method_30937() {
            return this;
        }

        public boolean accept(class_5224 visitor) {
            return class_5223.method_27476((class_5348)this, (class_2583)this.method_10866(), (class_5224)visitor);
        }

        public FoodHealthTooltipComponent getComponent() {
            return new FoodHealthTooltipComponent(this.foodNutrition);
        }
    }

    public static class FoodHealthTooltipComponent
    implements class_5684 {
        private final int heartsCount;
        private final boolean lastHeartIsHalf;

        FoodHealthTooltipComponent(int foodNutrition) {
            this.heartsCount = (int)Math.ceil((float)foodNutrition / 2.0f);
            this.lastHeartIsHalf = foodNutrition % 2 != 0;
        }

        public int method_32661(class_327 font) {
            return 14;
        }

        public int method_32664(class_327 font) {
            return this.heartsCount * 9;
        }

        public void method_32666(class_327 font, int x, int y, int width, int height, class_332 context) {
            y += 2;
            for (int i = 0; i < this.heartsCount - 1; ++i) {
                int textureX = x + i * 9;
                context.method_52706(class_10799.field_56883, class_329.class_6411.field_33944.method_52705(false, false, false), textureX, y, 9, 9);
                context.method_52706(class_10799.field_56883, class_329.class_6411.field_33945.method_52705(false, false, false), textureX, y, 9, 9);
            }
            int textureX = x + (this.heartsCount - 1) * 9;
            context.method_52706(class_10799.field_56883, class_329.class_6411.field_33944.method_52705(false, this.lastHeartIsHalf, false), textureX, y, 9, 9);
            context.method_52706(class_10799.field_56883, class_329.class_6411.field_33945.method_52705(false, this.lastHeartIsHalf, false), textureX, y, 9, 9);
        }
    }
}

