/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.config;

import antigers.melancholic_hunger.MelancholicHunger;
import antigers.melancholic_hunger.components.PlayerComponents;
import antigers.melancholic_hunger.components.ServerConfigComponent;
import antigers.melancholic_hunger.config.ClientConfigData;
import antigers.melancholic_hunger.config.ConfigOption;
import antigers.melancholic_hunger.config.HungerEffectOption;
import antigers.melancholic_hunger.config.ItemIntegerMapConfigOption;
import antigers.melancholic_hunger.config.ServerConfigData;
import antigers.melancholic_hunger.config.SprintingOption;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.lang.model.type.NullType;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4174;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class YACLConfig {
    private static final String CONFIG_PREFIX = "screen.melancholic_hunger.config.";
    @SerialEntry(value="clientOptions")
    private static ClientConfigData clientData = new ClientConfigData();
    @SerialEntry(value="serverOptions")
    private static ServerConfigData serverData = new ServerConfigData();
    private static final ConfigClassHandler<YACLConfig> HANDLER = ConfigClassHandler.createBuilder(YACLConfig.class).id(class_2960.method_60655((String)"melancholic_hunger", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("melancholic_hunger.json5")).setJson5(true).build()).build();
    private static final ConfigOption<Boolean, NullType> DISABLE_HUNGER = new ConfigOption("disableHunger", true, true, true, () -> YACLConfig.serverData.disableHunger, val -> {
        YACLConfig.serverData.disableHunger = val;
    });
    private static final ConfigOption<Boolean, Boolean> HIDE_HUNGER_BAR = new ConfigOption<Boolean, Boolean>("hideHungerBar", true, true, false, () -> YACLConfig.clientData.hideHungerBar, val -> {
        YACLConfig.clientData.hideHungerBar = val;
    }).addValueDependency(DISABLE_HUNGER, false, false, true);
    private static final ConfigOption<HungerEffectOption, Boolean> HUNGER_EFFECT = new ConfigOption<HungerEffectOption, Boolean>("hungerEffect", HungerEffectOption.REPLACED_WITH_POISON, true, true, () -> YACLConfig.serverData.hungerEffect, val -> {
        YACLConfig.serverData.hungerEffect = val;
    }).addValueDependency(DISABLE_HUNGER, true, HungerEffectOption.REPLACED_WITH_POISON, HungerEffectOption.VANILLA);
    private static final ConfigOption<Boolean, Boolean> HIGHLIGHT_RESTORED_HEARTS = new ConfigOption<Boolean, Boolean>("highlightRestoredHearts", true, false, false, () -> YACLConfig.clientData.highlightRestoredHearts, val -> {
        YACLConfig.clientData.highlightRestoredHearts = val;
    }).addValueDependency(DISABLE_HUNGER, true, true, false);
    private static final ConfigOption<Boolean, Boolean> GRADUAL_HEALTH_REGENERATION = new ConfigOption<Boolean, Boolean>("gradualHealthRegeneration", true, false, true, () -> YACLConfig.serverData.gradualHealthRegeneration, val -> {
        YACLConfig.serverData.gradualHealthRegeneration = val;
    }).addValueDependency(DISABLE_HUNGER, true, true, false);
    private static final ConfigOption<Float, Boolean> GRADUAL_HEALTH_REGENERATION_SPEED = new ConfigOption<Float, Boolean>("gradualHealthRegenerationSpeed", Float.valueOf(1.0f), false, true, () -> YACLConfig.serverData.gradualHealthRegenerationSpeed, val -> {
        YACLConfig.serverData.gradualHealthRegenerationSpeed = val;
    }).addDependency(GRADUAL_HEALTH_REGENERATION, true);
    private static final ConfigOption<Boolean, Boolean> HIGHLIGHT_REGENERATED_HEARTS = new ConfigOption<Boolean, Boolean>("highlightRegeneratedHearts", true, false, false, () -> YACLConfig.clientData.highlightRegeneratedHearts, val -> {
        YACLConfig.clientData.highlightRegeneratedHearts = val;
    }).addValueDependency(GRADUAL_HEALTH_REGENERATION, true, true, false);
    private static final ConfigOption<Boolean, Boolean> INSTANT_EATING = new ConfigOption("instantEating", false, true, true, () -> YACLConfig.serverData.instantEating, val -> {
        YACLConfig.serverData.instantEating = val;
    });
    private static final ConfigOption<Boolean, Boolean> SHOW_FOOD_ITEM_TOOLTIPS = new ConfigOption<Boolean, Boolean>("showFoodItemTooltips", true, false, true, () -> YACLConfig.serverData.showFoodItemTooltips, val -> {
        YACLConfig.serverData.showFoodItemTooltips = val;
    }).addValueDependency(DISABLE_HUNGER, true, true, false);
    private static final ConfigOption<SprintingOption, NullType> SPRINTING = new ConfigOption("sprinting", SprintingOption.LIMITED_BY_HEALTH, true, true, () -> YACLConfig.serverData.sprinting, val -> {
        YACLConfig.serverData.sprinting = val;
    });
    private static final ConfigOption<Integer, SprintingOption> SPRINTING_HEALTH_LIMIT = new ConfigOption<Integer, SprintingOption>("sprintingHealthLimit", 6, false, true, () -> YACLConfig.serverData.sprintingHealthLimit, val -> {
        YACLConfig.serverData.sprintingHealthLimit = val;
    }).addDependency(SPRINTING, SprintingOption.LIMITED_BY_HEALTH);
    private static final ConfigOption<Boolean, Boolean> USE_CUSTOM_FOOD_STACK_SIZES = new ConfigOption("useCustomFoodStackSizes", true, true, true, () -> YACLConfig.serverData.useCustomFoodStackSizes, val -> {
        YACLConfig.serverData.useCustomFoodStackSizes = val;
    });
    private static final ItemIntegerMapConfigOption CUSTOM_FOOD_STACK_SIZES = (ItemIntegerMapConfigOption)new ItemIntegerMapConfigOption("customFoodStackSizes", YACLConfig.getDefaultItemStackSizes(), true, true, () -> YACLConfig.serverData.customFoodStackSizes, val -> {
        YACLConfig.serverData.customFoodStackSizes = val;
    }).addDependency(USE_CUSTOM_FOOD_STACK_SIZES, (Object)true);
    private static final ConfigOption<Boolean, NullType> HIDE_EXPERIENCE_BAR = new ConfigOption("hideExperienceBar", true, true, false, () -> YACLConfig.clientData.hideExperienceBar, val -> {
        YACLConfig.clientData.hideExperienceBar = val;
    });
    private static final ConfigOption<Boolean, Boolean> SHOW_EXPERIENCE_IN_INVENTORY = new ConfigOption<Boolean, Boolean>("showExperienceInInventory", true, false, false, () -> YACLConfig.clientData.showExperienceInInventory, val -> {
        YACLConfig.clientData.showExperienceInInventory = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> SHOW_EXPERIENCE_ON_SCREENS = new ConfigOption<Boolean, Boolean>("showExperienceOnScreens", true, false, false, () -> YACLConfig.clientData.showExperienceOnScreens, val -> {
        YACLConfig.clientData.showExperienceOnScreens = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> SHOW_EXPERIENCE_ON_GAIN = new ConfigOption<Boolean, Boolean>("showExperienceOnGain", true, false, false, () -> YACLConfig.clientData.showExperienceOnGain, val -> {
        YACLConfig.clientData.showExperienceOnGain = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> ENABLE_EXPERIENCE_ANIMATION = new ConfigOption<Boolean, Boolean>("enableExperienceAnimation", true, false, false, () -> YACLConfig.clientData.enableExperienceAnimation, val -> {
        YACLConfig.clientData.enableExperienceAnimation = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, Boolean> RENDER_EXPERIENCE_OVER_BACKGROUND = new ConfigOption<Boolean, Boolean>("renderExperienceOverBackground", true, false, false, () -> YACLConfig.clientData.renderExperienceOverBackground, val -> {
        YACLConfig.clientData.renderExperienceOverBackground = val;
    }).addValueDependency(HIDE_EXPERIENCE_BAR, true, true, false);
    private static final ConfigOption<Boolean, NullType> HIDE_LOCATOR_BAR = new ConfigOption("hideLocatorBar", false, false, false, () -> YACLConfig.clientData.hideLocatorBar, val -> {
        YACLConfig.clientData.hideLocatorBar = val;
    });
    private static final List<ConfigOption<?, ?>> ALL_OPTIONS = List.of(DISABLE_HUNGER, GRADUAL_HEALTH_REGENERATION, GRADUAL_HEALTH_REGENERATION_SPEED, HIDE_HUNGER_BAR, HUNGER_EFFECT, HIGHLIGHT_REGENERATED_HEARTS, INSTANT_EATING, SHOW_FOOD_ITEM_TOOLTIPS, USE_CUSTOM_FOOD_STACK_SIZES, CUSTOM_FOOD_STACK_SIZES, SPRINTING, SPRINTING_HEALTH_LIMIT, HIGHLIGHT_RESTORED_HEARTS, HIDE_EXPERIENCE_BAR, SHOW_EXPERIENCE_IN_INVENTORY, SHOW_EXPERIENCE_ON_SCREENS, SHOW_EXPERIENCE_ON_GAIN, ENABLE_EXPERIENCE_ANIMATION, RENDER_EXPERIENCE_OVER_BACKGROUND, HIDE_LOCATOR_BAR);

    public static int getFoodHealth(class_1799 itemStack, class_4174 foodComponent) {
        return foodComponent.comp_2491();
    }

    private static LinkedHashMap<String, Integer> getDefaultItemStackSizes() {
        LinkedHashMap<class_1792, Integer> sizes = new LinkedHashMap<class_1792, Integer>();
        sizes.put(class_1802.field_8186, 64);
        sizes.put(class_1802.field_8551, 64);
        sizes.put(class_1802.field_8423, 32);
        sizes.put(class_1802.field_28659, 32);
        sizes.put(class_1802.field_8497, 32);
        sizes.put(class_1802.field_16998, 32);
        sizes.put(class_1802.field_8279, 16);
        sizes.put(class_1802.field_8367, 16);
        sizes.put(class_1802.field_8463, 16);
        sizes.put(class_1802.field_8567, 16);
        sizes.put(class_1802.field_8512, 16);
        sizes.put(class_1802.field_8635, 16);
        sizes.put(class_1802.field_8179, 16);
        sizes.put(class_1802.field_8071, 16);
        sizes.put(class_1802.field_8233, 16);
        sizes.put(class_1802.field_8229, 8);
        sizes.put(class_1802.field_8429, 8);
        sizes.put(class_1802.field_8373, 8);
        sizes.put(class_1802.field_8209, 8);
        sizes.put(class_1802.field_8509, 8);
        sizes.put(class_1802.field_8323, 8);
        sizes.put(class_1802.field_8846, 8);
        sizes.put(class_1802.field_8726, 8);
        sizes.put(class_1802.field_8544, 8);
        sizes.put(class_1802.field_8748, 8);
        sizes.put(class_1802.field_8347, 8);
        sizes.put(class_1802.field_8504, 8);
        sizes.put(class_1802.field_8752, 8);
        sizes.put(class_1802.field_20417, 8);
        sizes.put(class_1802.field_8046, 4);
        sizes.put(class_1802.field_8176, 4);
        sizes.put(class_1802.field_8389, 4);
        sizes.put(class_1802.field_8261, 4);
        sizes.put(class_1802.field_8741, 4);
        sizes.put(class_1802.field_8515, 1);
        sizes.put(class_1802.field_8208, 1);
        sizes.put(class_1802.field_8308, 1);
        sizes.put(class_1802.field_8766, 1);
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : sizes.entrySet()) {
            result.put(class_7923.field_41178.method_10221((Object)((class_1792)entry.getKey())).toString(), (Integer)entry.getValue());
        }
        return result;
    }

    private static BooleanControllerBuilder createBooleanController(Option<Boolean> option) {
        return BooleanControllerBuilder.create(option).yesNoFormatter().coloured(true);
    }

    private static ConfigCategory buildHungerCategory() {
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"screen.melancholic_hunger.config.hunger_category_name")).tooltip(new class_2561[]{class_2561.method_43471((String)"screen.melancholic_hunger.config.hunger_category_tooltip")}).option(DISABLE_HUNGER.buildYACLOption(YACLConfig::createBooleanController));
        if (MelancholicHunger.nostalgicTweaksInstalled) {
            builder.option(HIDE_HUNGER_BAR.buildYACLOption(YACLConfig::createBooleanController));
        }
        builder.option(HUNGER_EFFECT.buildYACLOption(option -> EnumControllerBuilder.create((Option)option).enumClass(HungerEffectOption.class).formatValue(value -> switch (value) {
            default -> throw new MatchException(null, null);
            case HungerEffectOption.VANILLA -> class_2561.method_43471((String)"screen.melancholic_hunger.config.hunger_effect_vanilla_option").method_10862(class_2583.field_24360.method_36139(0x55FF55));
            case HungerEffectOption.DISABLED -> class_2561.method_43471((String)"screen.melancholic_hunger.config.hunger_effect_disabled_option").method_10862(class_2583.field_24360.method_36139(0xFF5555));
            case HungerEffectOption.REPLACED_WITH_POISON -> class_2561.method_43471((String)"screen.melancholic_hunger.config.hunger_effect_replaced_with_poison_option").method_10862(class_2583.field_24360.method_36139(0xFFFF55));
        }))).option(HIGHLIGHT_RESTORED_HEARTS.buildYACLOption(YACLConfig::createBooleanController)).option(GRADUAL_HEALTH_REGENERATION.buildYACLOption(YACLConfig::createBooleanController)).option(GRADUAL_HEALTH_REGENERATION_SPEED.buildYACLOption(option -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(10.0f))).step((Number)Float.valueOf(0.1f)))).option(HIGHLIGHT_REGENERATED_HEARTS.buildYACLOption(YACLConfig::createBooleanController)).option(INSTANT_EATING.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_FOOD_ITEM_TOOLTIPS.buildYACLOption(YACLConfig::createBooleanController));
        return builder.build();
    }

    private static void setAllFoodStacksTo1(YACLScreen screen, ButtonOption button) {
        LinkedHashMap<String, Integer> stacks = YACLConfig.getDefaultItemStackSizes();
        stacks.replaceAll((k, v) -> 1);
        stacks.replace(class_1802.field_8423.toString(), 8);
        stacks.replace(class_1802.field_8186.toString(), 8);
        stacks.replace(class_1802.field_8179.toString(), 8);
        stacks.replace(class_1802.field_8233.toString(), 8);
        stacks.replace(class_1802.field_8497.toString(), 8);
        stacks.replace(class_1802.field_8567.toString(), 8);
        stacks.replace(class_1802.field_8635.toString(), 8);
        stacks.replace(class_1802.field_16998.toString(), 8);
        stacks.replace(class_1802.field_28659.toString(), 8);
        stacks.replace(class_1802.field_8551.toString(), 9);
        stacks.replace(class_1802.field_20417.toString(), 4);
        CUSTOM_FOOD_STACK_SIZES.updatePendingValue(stacks);
    }

    private static void setAllFoodStacksTo64(YACLScreen screen, ButtonOption button) {
        LinkedHashMap<String, Integer> stacks = YACLConfig.getDefaultItemStackSizes();
        stacks.replaceAll((k, v) -> 64);
        CUSTOM_FOOD_STACK_SIZES.updatePendingValue(stacks);
    }

    private static ButtonOption createButtonOption(String buttonName, BiConsumer<YACLScreen, ButtonOption> action, ConfigOption.ConfigOptionDependency<?> dependency) {
        boolean playerHasPermission = ConfigOption.getPlayerHasPermission();
        OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
        descriptionBuilder.text(new class_2561[]{class_2561.method_43471((String)("screen.melancholic_hunger.config.button." + buttonName + ".description"))});
        if (!playerHasPermission) {
            descriptionBuilder.text(new class_2561[]{class_2561.method_43470((String)"\n"), class_2561.method_43471((String)"screen.melancholic_hunger.config.op_privileges_required_option").method_10862(class_2583.field_24360.method_36139(0xFF5555).method_10978(Boolean.valueOf(true)))});
        }
        ButtonOption buttonOption = ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)("screen.melancholic_hunger.config.button." + buttonName + ".name"))).available(ConfigOption.getPlayerHasPermission()).description(descriptionBuilder.build()).text((class_2561)class_2561.method_43473()).action(action).build();
        dependency.configOption().YACLOption.addEventListener((option, event) -> {
            if (event != OptionEventListener.Event.STATE_CHANGE) {
                return;
            }
            buttonOption.setAvailable(dependency.isPendingValueEqualsRequired());
        });
        return buttonOption;
    }

    private static ConfigCategory buildFoodItemsCategory() {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"screen.melancholic_hunger.config.food_category_name")).tooltip(new class_2561[]{class_2561.method_43471((String)"screen.melancholic_hunger.config.food_category_tooltip")}).option(USE_CUSTOM_FOOD_STACK_SIZES.buildYACLOption(YACLConfig::createBooleanController)).option(CUSTOM_FOOD_STACK_SIZES.buildYACLOption()).option((Option)YACLConfig.createButtonOption("set_all_food_stack_sizes_to_1", YACLConfig::setAllFoodStacksTo1, new ConfigOption.ConfigOptionDependency<Boolean>(USE_CUSTOM_FOOD_STACK_SIZES, true))).option((Option)YACLConfig.createButtonOption("set_all_food_stack_sizes_to_64", YACLConfig::setAllFoodStacksTo64, new ConfigOption.ConfigOptionDependency<Boolean>(USE_CUSTOM_FOOD_STACK_SIZES, true))).build();
    }

    private static ConfigCategory buildSprintingCategory() {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"screen.melancholic_hunger.config.sprinting_category_name")).tooltip(new class_2561[]{class_2561.method_43471((String)"screen.melancholic_hunger.config.sprinting_category_tooltip")}).option(SPRINTING.buildYACLOption(option -> EnumControllerBuilder.create((Option)option).enumClass(SprintingOption.class).formatValue(value -> switch (value) {
            default -> throw new MatchException(null, null);
            case SprintingOption.VANILLA -> class_2561.method_43471((String)"screen.melancholic_hunger.config.sprinting_vanilla_option").method_10862(class_2583.field_24360.method_36139(0x55FF55));
            case SprintingOption.DISABLED -> class_2561.method_43471((String)"screen.melancholic_hunger.config.sprinting_disabled_option").method_10862(class_2583.field_24360.method_36139(0xFF5555));
            case SprintingOption.LIMITED_BY_HEALTH -> class_2561.method_43471((String)"screen.melancholic_hunger.config.sprinting_limited_by_health_option").method_10862(class_2583.field_24360.method_36139(0xFFFF55));
        }))).option(SPRINTING_HEALTH_LIMIT.buildYACLOption(option -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)1, (Number)20)).step((Number)1))).build();
    }

    private static ConfigCategory buildExperienceCategory() {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"screen.melancholic_hunger.config.experience_category_name")).tooltip(new class_2561[]{class_2561.method_43471((String)"screen.melancholic_hunger.config.experience_category_tooltip")}).option(HIDE_EXPERIENCE_BAR.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_EXPERIENCE_IN_INVENTORY.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_EXPERIENCE_ON_SCREENS.buildYACLOption(YACLConfig::createBooleanController)).option(SHOW_EXPERIENCE_ON_GAIN.buildYACLOption(YACLConfig::createBooleanController)).option(ENABLE_EXPERIENCE_ANIMATION.buildYACLOption(YACLConfig::createBooleanController)).option(RENDER_EXPERIENCE_OVER_BACKGROUND.buildYACLOption(YACLConfig::createBooleanController)).option(HIDE_LOCATOR_BAR.buildYACLOption(YACLConfig::createBooleanController)).build();
    }

    public static YetAnotherConfigLib getYACLInstance() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> builder.title((class_2561)class_2561.method_43471((String)"screen.melancholic_hunger.config.title")).category(YACLConfig.buildHungerCategory()).category(YACLConfig.buildFoodItemsCategory()).category(YACLConfig.buildSprintingCategory()).category(YACLConfig.buildExperienceCategory()).save(() -> {
            class_310 client = class_310.method_1551();
            boolean isSinglePlayer = client.method_47392();
            boolean hasSingleplayerServer = client.method_1496();
            class_746 player = client.field_1724;
            if (!MelancholicHunger.nostalgicTweaksInstalled) {
                YACLConfig.clientData.hideHungerBar = YACLConfig.serverData.disableHunger;
            }
            if (isSinglePlayer || player == null || hasSingleplayerServer) {
                HANDLER.save();
                if (hasSingleplayerServer) {
                    ServerConfigComponent.syncAllPlayersExceptOf(player.method_5628());
                }
            } else {
                ((ServerConfigComponent)PlayerComponents.SERVER_CONFIG.get((Object)player)).sendToServer(serverData.getImmutable());
            }
        }));
    }

    private static void updateCurrentScreen() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return;
        }
        if (class_310.method_1551().field_1755 instanceof YACLScreen) {
            ALL_OPTIONS.forEach(ConfigOption::forgetPendingValueIfServerOption);
        }
    }

    public static void loadFromDisk() {
        HANDLER.load();
        for (ConfigOption<?, ?> option : ALL_OPTIONS) {
            option.validateValue();
        }
        if (!MelancholicHunger.nostalgicTweaksInstalled) {
            HIDE_HUNGER_BAR.setValue(false);
        }
    }

    public static void saveToDisk() {
        HANDLER.save();
    }

    public static ClientConfigData.ImmutableClientConfigData getClientData() {
        return clientData.getImmutable();
    }

    public static void setClientData(ClientConfigData.ImmutableClientConfigData newClientData) {
        HIDE_HUNGER_BAR.setValue(newClientData.hideHungerBar());
        HIGHLIGHT_REGENERATED_HEARTS.setValue(newClientData.highlightRegeneratedHearts());
        HIGHLIGHT_RESTORED_HEARTS.setValue(newClientData.highlightRestoredHearts());
        HIDE_EXPERIENCE_BAR.setValue(newClientData.hideExperienceBar());
        SHOW_EXPERIENCE_IN_INVENTORY.setValue(newClientData.showExperienceInInventory());
        SHOW_EXPERIENCE_ON_SCREENS.setValue(newClientData.showExperienceOnScreens());
        SHOW_EXPERIENCE_ON_GAIN.setValue(newClientData.showExperienceOnScreens());
        ENABLE_EXPERIENCE_ANIMATION.setValue(newClientData.enableExperienceAnimation());
        RENDER_EXPERIENCE_OVER_BACKGROUND.setValue(newClientData.renderExperienceOverBackground());
        HIDE_LOCATOR_BAR.setValue(newClientData.hideLocatorBar());
    }

    public static ServerConfigData.ImmutableServerConfigData getServerData() {
        return serverData.getImmutable();
    }

    public static boolean setServerData(ServerConfigData.ImmutableServerConfigData newServerData) {
        if (serverData.getImmutable().equals(newServerData)) {
            return false;
        }
        DISABLE_HUNGER.setValue(newServerData.disableHunger());
        if (!MelancholicHunger.nostalgicTweaksInstalled) {
            HIDE_HUNGER_BAR.setValue(false);
        }
        HUNGER_EFFECT.setValue(newServerData.hungerEffect());
        GRADUAL_HEALTH_REGENERATION.setValue(newServerData.gradualHealthRegeneration());
        GRADUAL_HEALTH_REGENERATION_SPEED.setValue(newServerData.gradualHealthRegenerationSpeed());
        INSTANT_EATING.setValue(newServerData.instantEating());
        SHOW_FOOD_ITEM_TOOLTIPS.setValue(newServerData.showFoodItemTooltips());
        USE_CUSTOM_FOOD_STACK_SIZES.setValue(newServerData.useCustomFoodStackSizes());
        CUSTOM_FOOD_STACK_SIZES.setValue(newServerData.customFoodStackSizes());
        SPRINTING.setValue(newServerData.sprinting());
        SPRINTING_HEALTH_LIMIT.setValue(newServerData.sprintingHealthLimit());
        YACLConfig.updateCurrentScreen();
        return true;
    }

    public static boolean disableHunger() {
        return YACLConfig.serverData.disableHunger;
    }

    public static boolean hideHungerBar() {
        return YACLConfig.clientData.hideHungerBar;
    }

    public static boolean highlightRegeneratedHearts() {
        return YACLConfig.clientData.highlightRegeneratedHearts;
    }

    public static boolean highlightRestoredHearts() {
        return YACLConfig.clientData.highlightRestoredHearts;
    }

    public static HungerEffectOption hungerEffect() {
        return YACLConfig.serverData.hungerEffect;
    }

    public static boolean gradualHealthRegeneration() {
        return YACLConfig.serverData.gradualHealthRegeneration;
    }

    public static float gradualHealthRegenerationSpeed() {
        return YACLConfig.serverData.gradualHealthRegenerationSpeed.floatValue();
    }

    public static boolean instantEating() {
        return YACLConfig.serverData.instantEating;
    }

    public static boolean showFoodItemTooltips() {
        return YACLConfig.serverData.showFoodItemTooltips;
    }

    public static Integer getItemStackSize(class_1799 itemStack) {
        String itemId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        if (YACLConfig.serverData.useCustomFoodStackSizes.booleanValue() && YACLConfig.serverData.customFoodStackSizes.containsKey(itemId)) {
            return YACLConfig.serverData.customFoodStackSizes.get(itemId);
        }
        return null;
    }

    public static SprintingOption sprinting() {
        return YACLConfig.serverData.sprinting;
    }

    public static int sprintingHealthLimit() {
        return YACLConfig.serverData.sprintingHealthLimit;
    }

    public static boolean hideExperienceBar() {
        return YACLConfig.clientData.hideExperienceBar;
    }

    public static boolean showExperienceInInventory() {
        return YACLConfig.clientData.showExperienceInInventory;
    }

    public static boolean showExperienceOnScreens() {
        return YACLConfig.clientData.showExperienceOnScreens;
    }

    public static boolean showExperienceOnGain() {
        return YACLConfig.clientData.showExperienceOnGain;
    }

    public static boolean enableExperienceAnimation() {
        return YACLConfig.clientData.enableExperienceAnimation;
    }

    public static boolean renderExperienceOverBackground() {
        return YACLConfig.clientData.renderExperienceOverBackground;
    }

    public static boolean hideLocatorBar() {
        return YACLConfig.clientData.hideLocatorBar;
    }
}

