/*
 * Decompiled with CFR 0.152.
 */
package antigers.melancholic_hunger.hud;

import antigers.melancholic_hunger.config.YACLConfig;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_329;

public class BarAnimation {
    private static final int ANIMATION_TIME = 150;
    private long startTime;
    private boolean isRunning = false;
    private boolean reverse = true;
    private int currentPos = 0;
    private float currentOpacity = 0.0f;
    private class_329.class_11220 currentBarType;
    Predicate<class_329.class_11220> alwaysOnPredicate;

    public BarAnimation(Predicate<class_329.class_11220> alwaysOnPredicate) {
        this.alwaysOnPredicate = alwaysOnPredicate;
    }

    private void beginIfNotAlready(long now) {
        if (this.currentPos > 0 || this.isRunning) {
            return;
        }
        this.startTime = now;
        this.reverse = false;
        this.isRunning = true;
    }

    private void beginReverseIfNotAlready(long now) {
        if (this.currentPos < 7 || this.isRunning) {
            return;
        }
        this.startTime = now;
        this.reverse = true;
        this.isRunning = true;
    }

    public void update(class_329.class_11220 currentBarType, boolean shouldDraw) {
        long now = class_156.method_658();
        if (this.alwaysOnPredicate.test(currentBarType) || shouldDraw) {
            this.beginIfNotAlready(now);
        } else {
            this.beginReverseIfNotAlready(now);
        }
        if (!this.isRunning) {
            this.currentBarType = currentBarType;
        }
        if (YACLConfig.enableExperienceAnimation()) {
            long animationTime = now - this.startTime;
            if (animationTime < 150L) {
                this.currentOpacity = (float)animationTime / 150.0f;
                this.currentPos = (int)(this.currentOpacity * 7.0f);
            } else {
                this.currentOpacity = 1.0f;
                this.currentPos = 7;
                this.isRunning = false;
            }
        } else {
            this.currentOpacity = 1.0f;
            this.currentPos = 7;
            this.isRunning = false;
        }
        if (this.reverse) {
            this.currentOpacity = 1.0f - this.currentOpacity;
            this.currentPos = 7 - this.currentPos;
        }
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public float getCurrentOpacity() {
        return this.currentOpacity;
    }

    public boolean shouldStillDrawExperience() {
        return this.currentBarType == class_329.class_11220.field_59820 && this.isRunning;
    }
}

