/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.lib.snakeyaml.internal;

public class Logger {
    private final System.Logger logger;

    private Logger(String name) {
        this.logger = System.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level.level);
    }

    public void warn(String msg) {
        this.logger.log(Level.WARNING.level, msg);
    }

    public void debug(String msg) {
        this.logger.log(Level.DEBUG.level, msg);
    }

    public static enum Level {
        WARNING(System.Logger.Level.WARNING),
        DEBUG(System.Logger.Level.DEBUG);

        private final System.Logger.Level level;

        private Level(System.Logger.Level level) {
            this.level = level;
        }
    }
}

