/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.lib.configurate.interfaces;

import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.TypeUtils;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.Hidden;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.defaults.DefaultBoolean;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.defaults.DefaultDecimal;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.defaults.DefaultNumeric;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.defaults.DefaultString;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.range.DecimalRange;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.range.NumericRange;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.meta.range.StringRange;
import io.github.milkdrinkers.enderchester.lib.configurate.objectmapping.ObjectMapper;
import io.github.milkdrinkers.enderchester.lib.configurate.objectmapping.meta.Constraint;
import io.github.milkdrinkers.enderchester.lib.configurate.objectmapping.meta.Processor;
import io.github.milkdrinkers.enderchester.lib.configurate.serialize.SerializationException;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InterfaceMiddleware {
    private InterfaceMiddleware() {
    }

    static ObjectMapper.Factory.Builder buildObjectMapperWithMiddleware() {
        return ObjectMapper.factoryBuilder().addConstraint(DecimalRange.class, Number.class, InterfaceMiddleware.decimalRange()).addConstraint(NumericRange.class, Number.class, InterfaceMiddleware.numericRange()).addConstraint(StringRange.class, String.class, InterfaceMiddleware.stringRange()).addProcessor(Hidden.class, InterfaceMiddleware.hiddenProcessor());
    }

    private static Constraint.Factory<DecimalRange, Number> decimalRange() {
        return (data, type) -> number -> {
            if (number == null) {
                return;
            }
            double value = number.doubleValue();
            if (!(data.from() >= value) || !(data.to() <= value)) {
                throw new SerializationException(String.format(Locale.ROOT, "'%s' is not in the allowed range of from: %s, to: %s!", value, data.from(), data.to()));
            }
        };
    }

    private static Constraint.Factory<NumericRange, Number> numericRange() {
        return (data, type) -> number -> {
            if (number == null) {
                return;
            }
            long value = number.longValue();
            if (data.from() < value || data.to() > value) {
                throw new SerializationException(String.format(Locale.ROOT, "'%s' is not in the allowed range of from: %s, to: %s!", value, data.from(), data.to()));
            }
        };
    }

    private static Constraint.Factory<StringRange, String> stringRange() {
        return (data, type) -> string -> {
            if (string == null) {
                return;
            }
            int length = string.length();
            if (data.from() < length || data.to() > length) {
                throw new SerializationException(String.format(Locale.ROOT, "'%s' is not in the allowed string length range of from: %s, to: %s!", length, data.from(), data.to()));
            }
        };
    }

    private static Processor.AdvancedFactory<Hidden, Object> hiddenProcessor() {
        return (ignored, fieldType, element) -> {
            @Nullable DefaultBoolean defaultBoolean = element.getAnnotation(DefaultBoolean.class);
            @Nullable DefaultDecimal defaultDecimal = element.getAnnotation(DefaultDecimal.class);
            @Nullable DefaultNumeric defaultNumeric = element.getAnnotation(DefaultNumeric.class);
            @Nullable DefaultString defaultString = element.getAnnotation(DefaultString.class);
            boolean isBoolean = TypeUtils.isBoolean(fieldType);
            boolean isDecimal = TypeUtils.isDecimal(fieldType);
            boolean isNumeric = TypeUtils.isNumeric(fieldType);
            boolean isString = String.class == fieldType;
            return (value, destination) -> {
                if (isBoolean && defaultBoolean != null ? !value.equals(defaultBoolean.value()) : (isDecimal && defaultDecimal != null ? ((Number)value).doubleValue() != defaultDecimal.value() : (isNumeric && defaultNumeric != null ? ((Number)value).longValue() != defaultNumeric.value() : isString && defaultString != null && !defaultString.value().equals(value)))) {
                    return;
                }
                destination.parent().removeChild(destination.key());
            };
        };
    }
}

