/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.lib.configurate.interfaces;

import io.github.milkdrinkers.enderchester.lib.configurate.ConfigurationNode;
import io.github.milkdrinkers.enderchester.lib.configurate.objectmapping.ConfigSerializable;
import io.github.milkdrinkers.enderchester.lib.configurate.serialize.SerializationException;
import io.github.milkdrinkers.enderchester.lib.configurate.serialize.TypeSerializer;
import io.github.milkdrinkers.enderchester.lib.geantyref.GenericTypeReflector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InterfaceTypeSerializer
implements TypeSerializer<Object> {
    public static final InterfaceTypeSerializer INSTANCE = new InterfaceTypeSerializer();
    private final Properties interfaceMappings = new Properties();

    public static boolean applicable(AnnotatedType type) {
        return type.isAnnotationPresent(ConfigSerializable.class) && GenericTypeReflector.erase(type.getType()).isInterface();
    }

    private InterfaceTypeSerializer() {
        @Nullable URL mappingsUrl = this.getClass().getClassLoader().getResource("io/github/milkdrinkers/enderchester/lib/configurate/interfaces/interface_mappings.properties");
        if (mappingsUrl == null) {
            return;
        }
        try (InputStream stream = mappingsUrl.openStream();){
            this.interfaceMappings.load(stream);
        }
        catch (IOException exception) {
            throw new RuntimeException("Could not load interface mappings!", exception);
        }
    }

    @Override
    public Object deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Class<?> implClass;
        String canonicalName = GenericTypeReflector.erase(type).getTypeName();
        @Nullable String typeImpl = this.interfaceMappings.getProperty(canonicalName);
        if (typeImpl == null) {
            throw new SerializationException(String.format(Locale.ROOT, "No mapping found for type %s. Available mappings: %s", canonicalName, this.availableMappings()));
        }
        try {
            implClass = Class.forName(typeImpl, true, GenericTypeReflector.erase(type).getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            throw new SerializationException(String.format(Locale.ROOT, "Could not find implementation class %s for type %s!", typeImpl, canonicalName));
        }
        @Nullable TypeSerializer<?> serializer = node.options().serializers().get(implClass);
        if (serializer == null) {
            throw new SerializationException("No serializer found for implementation class " + implClass);
        }
        return serializer.deserialize(implClass, node);
    }

    @Override
    public void serialize(Type type, @Nullable Object obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        @Nullable TypeSerializer<?> serializer = node.options().serializers().get(obj.getClass());
        if (serializer == null) {
            throw new SerializationException("No serializer found for implementation class " + obj.getClass());
        }
        serializer.serialize(obj.getClass(), obj, node);
    }

    private String availableMappings() {
        StringJoiner joiner = new StringJoiner(", ");
        this.interfaceMappings.keySet().forEach(key -> joiner.add((CharSequence)key));
        return joiner.toString();
    }
}

