/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling;

import io.github.milkdrinkers.enderchester.lib.morepaperlib.MorePaperLib;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.AsynchronousScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.AttachedScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.BukkitSchedulerAsAsynchronousScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.BukkitSchedulerAsRegionalScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.EntitySpecificScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.FoliaDetection;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.GlobalAsyncScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.GlobalScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.RegionSpecificScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.RegionalScheduler;
import io.github.milkdrinkers.enderchester.lib.morepaperlib.scheduling.StandardFoliaDetection;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Contract;

public class GracefulScheduling {
    private final MorePaperLib morePaperLib;
    private final FoliaDetection foliaDetection;

    public GracefulScheduling(MorePaperLib morePaperLib, FoliaDetection foliaDetection) {
        this.morePaperLib = morePaperLib;
        this.foliaDetection = foliaDetection;
    }

    public GracefulScheduling(MorePaperLib morePaperLib) {
        this(morePaperLib, StandardFoliaDetection.INSTANCE);
    }

    public boolean isUsingFolia() {
        return this.foliaDetection.isUsingFolia();
    }

    @Contract(value="-> new", pure=true)
    public AsynchronousScheduler asyncScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalAsyncScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsAsynchronousScheduler(this.morePaperLib);
    }

    @Contract(value="-> new", pure=true)
    public RegionalScheduler globalRegionalScheduler() {
        if (this.isUsingFolia()) {
            return new GlobalScheduler(this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    @Contract(value="_ -> new", pure=true)
    public RegionalScheduler regionSpecificScheduler(Location location) {
        return this.regionSpecificScheduler(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public RegionalScheduler regionSpecificScheduler(World world, int chunkX, int chunkZ) {
        if (this.isUsingFolia()) {
            return new RegionSpecificScheduler(this.morePaperLib.getPlugin(), world, chunkX, chunkZ);
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib);
    }

    @Contract(value="_ -> new", pure=true)
    public AttachedScheduler entitySpecificScheduler(Entity entity) {
        if (this.isUsingFolia()) {
            return new EntitySpecificScheduler(entity, this.morePaperLib.getPlugin());
        }
        return new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).asAttachedScheduler();
    }

    public boolean isOnGlobalRegionThread() {
        Server server = this.morePaperLib.getPlugin().getServer();
        if (this.isUsingFolia()) {
            return server.isGlobalTickThread();
        }
        return server.isPrimaryThread();
    }

    public void cancelGlobalTasks() {
        if (this.isUsingFolia()) {
            new GlobalAsyncScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            new GlobalScheduler(this.morePaperLib.getPlugin()).cancelTasks();
            return;
        }
        new BukkitSchedulerAsRegionalScheduler(this.morePaperLib).cancelTasks();
    }
}

