/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.config;

import io.github.milkdrinkers.enderchester.Enderchester;
import io.github.milkdrinkers.enderchester.Reloadable;
import io.github.milkdrinkers.enderchester.config.EnderChesterConfig;
import io.github.milkdrinkers.enderchester.lib.configurate.CommentedConfigurationNode;
import io.github.milkdrinkers.enderchester.lib.configurate.interfaces.InterfaceDefaultOptions;
import io.github.milkdrinkers.enderchester.lib.configurate.util.MapFactories;
import io.github.milkdrinkers.enderchester.lib.configurate.yaml.NodeStyle;
import io.github.milkdrinkers.enderchester.lib.configurate.yaml.YamlConfigurationLoader;
import io.github.milkdrinkers.enderchester.utility.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ConfigHandler
implements Reloadable {
    private final Enderchester plugin;
    private EnderChesterConfig config;

    public ConfigHandler(Enderchester plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onLoad() {
        Path configPath = this.plugin.getDataFolder().toPath().resolve("config.yml");
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configPath)).indent(2).nodeStyle(NodeStyle.BLOCK).defaultOptions(options -> InterfaceDefaultOptions.defaults().shouldCopyDefaults(false).header("EnderChester by darksaid98\nFor more info see https://github.com/milkdrinkers/Enderchester").mapFactory(MapFactories.insertionOrdered()))).commentsEnabled(true).build();
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.saveDefaultConfig(loader);
        }
        this.loadConfig(loader);
    }

    private void saveDefaultConfig(YamlConfigurationLoader loader) {
        CommentedConfigurationNode rootNode = CommentedConfigurationNode.root(loader.defaultOptions());
        try {
            EnderChesterConfig config = rootNode.get(EnderChesterConfig.class);
            rootNode.set(config);
            loader.save(rootNode);
        }
        catch (Exception e) {
            Logger.get().error("Failed to save default config: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void loadConfig(YamlConfigurationLoader loader) {
        try {
            CommentedConfigurationNode rootNode = (CommentedConfigurationNode)loader.load();
            this.config = rootNode.get(EnderChesterConfig.class);
            if (this.config == null) {
                this.config = new EnderChesterConfig();
                System.out.println("Using default configuration values");
            }
        }
        catch (Exception e) {
            Logger.get().error("Failed to load config, using defaults options: {}", (Object)e.getMessage(), (Object)e);
            this.config = new EnderChesterConfig();
        }
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }

    public EnderChesterConfig getConfig() {
        return this.config;
    }
}

