/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.config;

import io.github.milkdrinkers.enderchester.lib.configurate.objectmapping.ConfigSerializable;
import io.github.milkdrinkers.enderchester.lib.configurate.objectmapping.meta.Comment;
import java.util.ArrayList;
import java.util.List;

@ConfigSerializable
public class EnderChesterConfig {
    public CheckSection check = new CheckSection();
    public SoundSection sound = new SoundSection();
    @Comment(value="Do not change this value!")
    public int configVersion = 2;

    @ConfigSerializable
    public static class CheckSection {
        @Comment(value="Should we check the player for the permission \"enderchester.use\"")
        public boolean permission = true;
        @Comment(value="Should we disallow opening enderchests through the plugin when in creative mode?")
        public boolean creative = false;
        @Comment(value="A list of worldnames where players won't be able to open enderchests through the plugin")
        public BlackListSection blacklist = new BlackListSection();
        @Comment(value="A list of worldnames where players will be able to open enderchests through the plugin")
        public WhiteListSection whitelist = new WhiteListSection();

        @ConfigSerializable
        public static class BlackListSection {
            @Comment(value="Whether the blacklist should be used or not")
            public boolean enabled = false;
            public List<String> worlds = new ArrayList<String>(List.of("worldname1", "someworldname2"));
        }

        @ConfigSerializable
        public static class WhiteListSection {
            @Comment(value="Whether the whitelist should be used or not")
            public boolean enabled = false;
            public List<String> worlds = new ArrayList<String>(List.of("worldname1", "someworldname2"));
        }
    }

    @ConfigSerializable
    public static class SoundSection {
        @Comment(value="Should a ender chest opening sound be played when it is opened through the plugin?")
        public boolean opening = true;
        @Comment(value="Can be any value between 0 and 1. For example, 0.8 would be at 80% volume.")
        public float volume = 1.0f;
        @Comment(value="The sound that will be played. If the selected sound does not exist, it will default to ender chest opening sound")
        public String effect = "minecraft:block.ender_chest.open";
    }
}

