/*
 * Decompiled with CFR 0.152.
 */
package io.github.milkdrinkers.enderchester.listener;

import io.github.milkdrinkers.enderchester.Enderchester;
import io.github.milkdrinkers.enderchester.api.event.EnderchestOpenedEvent;
import io.github.milkdrinkers.enderchester.api.event.PreEnderchestOpenedEvent;
import io.github.milkdrinkers.enderchester.api.type.OpenMethod;
import io.github.milkdrinkers.enderchester.config.EnderChesterConfig;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class EnderChestListener
implements Listener {
    private final EnderChesterConfig config;

    public EnderChestListener(EnderChesterConfig config) {
        this.config = config;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInteract(InventoryClickEvent e) {
        if (!e.getClick().equals((Object)ClickType.RIGHT)) {
            return;
        }
        if (e.getView().getTopInventory().getType().equals((Object)InventoryType.ENDER_CHEST)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        ItemStack item = e.getCurrentItem();
        if (item == null) {
            return;
        }
        if (this.openEnderChest(p, item, OpenMethod.INVENTORY)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = e.getItem();
        if (item == null) {
            return;
        }
        if (this.openEnderChest(p, item, OpenMethod.HOTBAR)) {
            e.setCancelled(true);
        }
    }

    private boolean openEnderChest(Player p, ItemStack item, OpenMethod openMethod) {
        if (!item.getType().equals((Object)Material.ENDER_CHEST)) {
            return false;
        }
        if (this.config.check.permission && !p.hasPermission("enderchester.use")) {
            return false;
        }
        if (this.config.check.creative && p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return false;
        }
        if (this.config.check.blacklist.enabled && this.config.check.blacklist.worlds.contains(p.getWorld().getName())) {
            return false;
        }
        if (this.config.check.whitelist.enabled && !this.config.check.whitelist.worlds.contains(p.getWorld().getName())) {
            return false;
        }
        Enderchester.getInstance().getMorePaperLib().scheduling().regionSpecificScheduler(p.getLocation()).run(() -> {
            boolean eventCall = new PreEnderchestOpenedEvent(p, openMethod).callEvent();
            if (!eventCall) {
                return;
            }
            p.openInventory(p.getEnderChest());
            if (this.config.sound.opening) {
                try {
                    String soundId = this.config.sound.effect;
                    Sound sound = (Sound)Sound.sound().type(Key.key((String)soundId)).source(Sound.Source.BLOCK).volume(this.config.sound.volume).pitch(1.0f).build();
                    p.playSound(sound);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            new EnderchestOpenedEvent(p, openMethod).callEvent();
        });
        return true;
    }
}

