/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.blocks.SerializationFlags;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class TileCapabilityManager {
    private Map<BlockCapability<?, Direction>, Map<Direction, Object>> capabilityMap = new HashMap();
    private Map<Object, Predicate<Direction>> capSideValidator = new HashMap<Object, Predicate<Direction>>();
    private Map<INBTSerializable<CompoundTag>, SerializationFlags<?>> serializableMap = new HashMap();
    private List<SerializationFlags<?>> indexedDataList = new ArrayList();
    private TileBCore tile;

    public TileCapabilityManager(TileBCore tile) {
        this.tile = tile;
    }

    public <T> void set(@Nonnull BlockCapability<?, Direction> cap, @Nonnull T capInstance, Direction ... sides) {
        if (sides == null) {
            return;
        }
        if (sides.length == 0) {
            sides = Direction.values();
            this.setSide(cap, capInstance, null);
        }
        for (Direction dir : sides) {
            this.setSide(cap, capInstance, dir);
        }
    }

    public <T extends INBTSerializable<CompoundTag>> SerializationFlags<T> setManaged(String tagName, @Nonnull BlockCapability<?, Direction> cap, @Nonnull T capInstance, Direction ... sides) {
        this.set(cap, capInstance, sides);
        SerializationFlags<T> flags = new SerializationFlags<T>(tagName, capInstance);
        this.serializableMap.put(capInstance, flags);
        this.indexedDataList.add(flags);
        return flags;
    }

    public <T extends INBTSerializable<CompoundTag>> SerializationFlags<T> setInternalManaged(String tagName, @Nonnull BlockCapability<?, Direction> cap, @Nonnull T capInstance) {
        SerializationFlags<T> flags = new SerializationFlags<T>(tagName, capInstance);
        this.serializableMap.put(capInstance, flags);
        this.indexedDataList.add(flags);
        return flags;
    }

    public void remove(@Nonnull BlockCapability<?, Direction> cap, Direction ... sides) {
        if (sides.length == 0) {
            sides = Direction.values();
            this.clearSide(cap, null);
        }
        for (Direction dir : sides) {
            this.clearSide(cap, dir);
        }
    }

    public <T> void setSide(@Nonnull BlockCapability<?, Direction> cap, @Nonnull T capInstance, @Nullable Direction side) {
        Map map = this.capabilityMap.computeIfAbsent(cap, c -> new HashMap());
        Object previous = map.get(side);
        map.put(side, capInstance);
    }

    public <T> void clearSide(@Nonnull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        Map<Direction, Object> map = this.capabilityMap.get(cap);
        if (map != null) {
            Object previous = map.get(side);
            map.remove(side);
        }
    }

    @Nullable
    public <T> T getCapability(@Nonnull BlockCapability<T, Direction> cap, @Nullable Direction side) {
        Object capOnSide;
        Map<Direction, Object> map = this.capabilityMap.get(cap);
        if (map == null && cap == Capabilities.EnergyStorage.BLOCK) {
            map = this.capabilityMap.get(CapabilityOP.BLOCK);
        }
        if (map != null && map.containsKey(side) && this.capSideValidator.getOrDefault(capOnSide = map.get(side), d -> true).test(side)) {
            return (T)capOnSide;
        }
        return null;
    }

    public void invalidate() {
    }

    public void setCapSideValidator(Object capabilityInstance, Predicate<Direction> predicate) {
        this.capSideValidator.put(capabilityInstance, predicate);
    }

    public CompoundTag serialize(boolean forItem) {
        CompoundTag compound = new CompoundTag();
        for (SerializationFlags<?> helper : this.serializableMap.values()) {
            if ((!forItem || !helper.saveItem) && (forItem || !helper.saveTile)) continue;
            compound.put(helper.tagName, helper.getData().serializeNBT((HolderLookup.Provider)this.tile.getLevel().registryAccess()));
        }
        return compound;
    }

    public void deserialize(HolderLookup.Provider provider, CompoundTag compound) {
        for (SerializationFlags<?> helper : this.serializableMap.values()) {
            helper.lazyLoadDefault(provider);
            if (!compound.contains(helper.tagName)) continue;
            helper.getData().deserializeNBT(provider, (Tag)compound.getCompound(helper.tagName));
        }
    }

    public void detectAndSendChanges() {
        for (int i = 0; i < this.indexedDataList.size(); ++i) {
            SerializationFlags<?> helper = this.indexedDataList.get(i);
            if (!helper.syncTile || !helper.hasChanged(true, (HolderLookup.Provider)this.tile.getLevel().registryAccess())) continue;
            PacketCustom packet = this.createCapPacket(helper, i);
            packet.sendToChunk((BlockEntity)this.tile);
        }
    }

    public void detectAndSendChangesToListeners(Collection<Player> listeners) {
        for (int i = 0; i < this.indexedDataList.size(); ++i) {
            SerializationFlags<?> helper = this.indexedDataList.get(i);
            if (!helper.syncContainer || !helper.hasChanged(true, (HolderLookup.Provider)this.tile.getLevel().registryAccess())) continue;
            PacketCustom packet = this.createCapPacket(helper, i);
            DataUtils.forEachMatch(listeners, p -> p instanceof ServerPlayer, p -> packet.sendToPlayer((ServerPlayer)p));
        }
    }

    private PacketCustom createCapPacket(SerializationFlags<?> helper, int index) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL_NAME, 8, this.tile.getLevel().registryAccess());
        packet.writePos(this.tile.getBlockPos());
        packet.writeInt(index);
        if (helper.getData() instanceof IMCDataSerializable) {
            ((IMCDataSerializable)helper.getData()).serializeMCD((MCDataOutput)packet);
        } else {
            packet.writeCompoundNBT((CompoundTag)helper.getData().serializeNBT((HolderLookup.Provider)this.tile.getLevel().registryAccess()));
        }
        return packet;
    }

    public void receiveCapSyncData(MCDataInput input) {
        int index = input.readInt();
        if (index >= 0 && index < this.indexedDataList.size()) {
            SerializationFlags<?> helper = this.indexedDataList.get(index);
            if (helper.getData() instanceof IMCDataSerializable) {
                ((IMCDataSerializable)helper.getData()).deSerializeMCD(input);
            } else {
                helper.getData().deserializeNBT((HolderLookup.Provider)this.tile.getLevel().registryAccess(), (Tag)input.readCompoundNBT());
            }
        }
    }
}

