/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.templates;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.Direction;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import java.util.LinkedList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ButtonRow
extends GuiElement<ButtonRow> {
    private final LinkedList<GuiElement<?>> buttons = new LinkedList();
    private GuiElement<?> lastElement;
    private final Direction layoutDirection;
    private double width = 12.0;
    private double height = 12.0;
    private double spacing = 0.0;

    public ButtonRow(@NotNull GuiParent<?> parent, Direction layoutDirection) {
        super(parent);
        this.layoutDirection = layoutDirection;
        this.lastElement = new GuiElement((GuiParent)this);
        Constraints.size(this.lastElement, (double)0.0, (double)0.0);
        switch (layoutDirection) {
            case UP: {
                ((GuiElement)this.lastElement.constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)));
                this.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.width));
                this.constrain(GeoParam.TOP, (Constraint)Constraint.dynamic(() -> this.lastElement.getValue(GeoParam.TOP)));
                break;
            }
            case LEFT: {
                ((GuiElement)this.lastElement.constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)));
                this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.height));
                this.constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> this.lastElement.getValue(GeoParam.LEFT)));
                break;
            }
            case DOWN: {
                ((GuiElement)this.lastElement.constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)));
                this.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.width));
                this.constrain(GeoParam.BOTTOM, (Constraint)Constraint.dynamic(() -> this.lastElement.getValue(GeoParam.BOTTOM)));
                break;
            }
            case RIGHT: {
                ((GuiElement)this.lastElement.constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)));
                this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.height));
                this.constrain(GeoParam.RIGHT, (Constraint)Constraint.dynamic(() -> this.lastElement.getValue(GeoParam.RIGHT)));
            }
        }
    }

    public ButtonRow(@NotNull GuiParent<?> parent) {
        this(parent, Direction.DOWN);
    }

    public ButtonRow setButtonSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public ButtonRow setSpacing(double spacing) {
        this.spacing = spacing;
        return this;
    }

    public void addButton(Function<ButtonRow, GuiElement<?>> buttonFunc) {
        GuiElement<?> button = buttonFunc.apply(this);
        GuiElement<?> finalLast = this.lastElement;
        boolean first = this.buttons.isEmpty();
        switch (this.layoutDirection) {
            case UP: {
                ((GuiElement)((GuiElement)((GuiElement)button.constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)finalLast.get(GeoParam.TOP), () -> !first && button.isEnabled() ? -this.spacing : 0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.width))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> button.isEnabled() ? this.height : 0.0));
                break;
            }
            case LEFT: {
                ((GuiElement)((GuiElement)((GuiElement)button.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)finalLast.get(GeoParam.LEFT), () -> !first && button.isEnabled() ? -this.spacing : 0.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.height))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> button.isEnabled() ? this.width : 0.0));
                break;
            }
            case DOWN: {
                ((GuiElement)((GuiElement)((GuiElement)button.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)finalLast.get(GeoParam.BOTTOM), () -> !first && button.isEnabled() ? this.spacing : 0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.width))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> button.isEnabled() ? this.height : 0.0));
                break;
            }
            case RIGHT: {
                ((GuiElement)((GuiElement)((GuiElement)button.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)finalLast.get(GeoParam.RIGHT), () -> !first && button.isEnabled() ? this.spacing : 0.0))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.height))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> button.isEnabled() ? this.width : 0.0));
            }
        }
        this.lastElement = button;
        this.buttons.add(button);
    }

    public static ButtonRow topRightInside(GuiElement<?> parent, Direction layoutDirection, int xOffset, int yOffset) {
        ButtonRow buttonRow = new ButtonRow((GuiParent<?>)parent, layoutDirection);
        Constraints.placeInside((ConstrainedGeometry)buttonRow, parent, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)(-xOffset), (double)yOffset);
        return buttonRow;
    }

    public static ButtonRow topLeftInside(GuiElement<?> parent, Direction layoutDirection, int xOffset, int yOffset) {
        ButtonRow buttonRow = new ButtonRow((GuiParent<?>)parent, layoutDirection);
        Constraints.placeInside((ConstrainedGeometry)buttonRow, parent, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)xOffset, (double)yOffset);
        return buttonRow;
    }

    public static ButtonRow bottomRightInside(GuiElement<?> parent, Direction layoutDirection, int xOffset, int yOffset) {
        ButtonRow buttonRow = new ButtonRow((GuiParent<?>)parent, layoutDirection);
        Constraints.placeInside((ConstrainedGeometry)buttonRow, parent, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)(-xOffset), (double)(-yOffset));
        return buttonRow;
    }

    public static ButtonRow bottomLeftInside(GuiElement<?> parent, Direction layoutDirection, int xOffset, int yOffset) {
        ButtonRow buttonRow = new ButtonRow((GuiParent<?>)parent, layoutDirection);
        Constraints.placeInside((ConstrainedGeometry)buttonRow, parent, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)xOffset, (double)(-yOffset));
        return buttonRow;
    }
}

