/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers.contributor;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.ClientOnly;
import com.brandon3055.brandonscore.handlers.contributor.ContributorConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.utils.Utils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Animations {
    private ContributorProperties props;
    private float wingBoneCol = 0.0f;
    private float wingBoneColSpeed = 0.0f;
    private float wingWebCol = 0.0f;
    private float wingWebColSpeed = 0.0f;
    private float shieldCol = 0.0f;
    private float shieldColSpeed = 0.0f;
    private float wingExt = 0.0f;
    private float lastWingExt = 0.0f;
    private float targetWingExt = 0.0f;
    private float extAprSpeed = 0.0f;
    private float wingFold = 0.0f;
    private float lastWingFold = 0.0f;
    private float targetWingFold = 0.0f;
    private float foldAprSpeed = 0.0f;
    private float wingFlap = 0.0f;
    private float wingFlap2 = 0.0f;
    private float lastWingFlap = 0.0f;
    private float lastWingFlap2 = 0.0f;
    private float targetWingFlap = 0.0f;
    private float targetWingFlap2 = 0.0f;
    private float flapAprSpeed = 0.0f;
    private float flap2AprSpeed = 0.0f;
    private float flapDir = 0.0f;
    private float lastVelocity = 0.0f;
    private float flapSpeed = 0.0f;
    private float wingPitch = 0.0f;
    private float lastWingPitch = 0.0f;
    private float targetWingPitch = 0.0f;
    private float pitchAprSpeed = 0.0f;
    private boolean hideWings = true;
    private float hideAnim = 2.0f;
    private int playerExpiry = 0;
    private Player player = null;

    public Animations(ContributorProperties props) {
        this.props = props;
    }

    public void setPlayer(Player player) {
        this.player = player;
        this.playerExpiry = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tick() {
        float s;
        Boolean paused = (Boolean)Utils.unsafeCallWhenOn(Dist.CLIENT, () -> ClientOnly::isClientPaused);
        if (paused != null && paused.booleanValue()) {
            return;
        }
        ContributorConfig config = this.props.getConfig();
        if (config.getWingRGBBoneColour()) {
            s = ContributorConfig.unpack(config.getWingsOverrideBoneColour())[0];
            this.wingBoneColSpeed = s * s * 0.05f;
            this.wingBoneCol += this.wingBoneColSpeed;
            this.wingBoneCol %= 1.0f;
        }
        if (config.getWingRGBWebColour()) {
            s = ContributorConfig.unpack(config.getWingsOverrideWebColour())[0];
            this.wingWebColSpeed = s * s * 0.05f;
            this.wingWebCol += this.wingWebColSpeed;
            this.wingWebCol %= 1.0f;
        }
        if (config.getShieldRGB()) {
            s = ContributorConfig.unpack(config.getShieldOverride())[0];
            this.shieldColSpeed = s * s * 0.05f;
            this.shieldCol += this.shieldColSpeed;
            this.shieldCol %= 1.0f;
        }
        if (this.props.hasWings() && this.player != null) {
            this.tickWings(this.player, config);
        }
        if (this.player != null && this.playerExpiry++ > 1200) {
            this.player = null;
        }
    }

    private void tickWings(Player player, ContributorConfig config) {
        this.lastWingExt = this.wingExt;
        this.lastWingFold = this.wingFold;
        this.lastWingFlap = this.wingFlap;
        this.lastWingFlap2 = this.wingFlap2;
        this.lastWingPitch = this.wingPitch;
        this.pitchAprSpeed = 0.1f;
        this.foldAprSpeed = 0.1f;
        this.extAprSpeed = 0.1f;
        this.flapAprSpeed = 0.05f;
        this.flap2AprSpeed = 0.1f;
        this.targetWingFold = 0.0f;
        this.targetWingExt = 0.0f;
        this.hideWings = false;
        float hideSpeed = 0.1f;
        ItemStack chest = player.getItemBySlot(EquipmentSlot.CHEST);
        boolean hasElytra = chest.getItem().canElytraFly(chest, (LivingEntity)player);
        if (!hasElytra && BrandonsCore.equipmentManager != null) {
            boolean bl = hasElytra = !BrandonsCore.equipmentManager.findMatchingItem(e -> e.getItem().canElytraFly(e, (LivingEntity)player), (LivingEntity)player).isEmpty();
        }
        if (config.getWingsTier() == null || hasElytra && config.getWingsElytra() == ContributorConfig.WingElytraCompat.HIDE_WINGS) {
            this.hideWings = true;
        } else if (!hasElytra && config.getWingsElytra() == ContributorConfig.WingElytraCompat.REPLACE) {
            this.hideWings = true;
        } else if (player.isFallFlying()) {
            float diveInv = 1.0f;
            Vec3 speed = player.getDeltaMovement();
            float velocity = (float)speed.length();
            float velDelta = velocity - this.lastVelocity;
            this.lastVelocity = velocity;
            if (speed.y < 0.0) {
                Vec3 direction = speed.normalize();
                diveInv = 1.0f - (float)Math.pow(-direction.y, 1.5);
            }
            float dive = 1.0f - diveInv;
            this.targetWingExt = diveInv;
            this.targetWingFold = 1.0f - dive * 0.5f;
            float vertical = (float)speed.y + 0.1f;
            float newFlapSpeed = MathHelper.clip((float)((MathHelper.clip((float)velDelta, (float)0.0f, (float)1.0f) - MathHelper.clip((float)(-vertical), (float)0.0f, (float)1.0f)) * 10.0f), (float)0.0f, (float)0.1f);
            this.flapSpeed = newFlapSpeed > this.flapSpeed ? newFlapSpeed : MathHelper.approachLinear((float)this.flapSpeed, (float)newFlapSpeed, (float)0.005f);
            this.doFlapAnimation(this.flapSpeed, 4.0f, 2.0f, 0.25f, -0.5f, 2.5f);
            this.lastVelocity = velocity;
            hideSpeed = 0.25f;
        } else if (player.getAbilities().flying) {
            this.doWingBehavior(config.getWingsCreative());
        } else {
            this.doWingBehavior(config.getWingsGround());
        }
        this.wingExt = MathHelper.approachLinear((float)this.wingExt, (float)this.targetWingExt, (float)this.extAprSpeed);
        this.wingFold = MathHelper.approachLinear((float)this.wingFold, (float)this.targetWingFold, (float)this.foldAprSpeed);
        this.wingFlap = MathHelper.approachLinear((float)this.wingFlap, (float)this.targetWingFlap, (float)this.flapAprSpeed);
        this.wingFlap2 = MathHelper.approachLinear((float)this.wingFlap2, (float)this.targetWingFlap2, (float)this.flap2AprSpeed);
        this.wingPitch = MathHelper.approachLinear((float)this.wingPitch, (float)this.targetWingPitch, (float)this.pitchAprSpeed);
        this.hideAnim = MathHelper.approachLinear((float)this.hideAnim, (float)(this.hideWings ? 2.0f : 0.0f), (float)hideSpeed);
        if (this.hideAnim > 0.0f) {
            this.wingExt = MathHelper.clip((float)Math.min(this.wingExt, 1.0f - this.hideAnim), (float)0.0f, (float)1.0f);
            this.wingFold = MathHelper.clip((float)Math.min(this.wingFold, 1.0f - this.hideAnim), (float)0.0f, (float)1.0f);
            this.wingFlap = MathHelper.clip((float)Math.min(this.wingFlap, 1.0f - this.hideAnim), (float)0.0f, (float)1.0f);
            this.wingFlap2 = MathHelper.clip((float)Math.min(this.wingFlap2, 1.0f - this.hideAnim), (float)0.0f, (float)1.0f);
            this.wingPitch = MathHelper.clip((float)Math.min(this.wingPitch, 1.0f - this.hideAnim), (float)0.0f, (float)1.0f);
        }
    }

    private void doWingBehavior(ContributorConfig.WingBehavior behavior) {
        switch (behavior) {
            case HIDE: {
                this.hideWings = true;
                break;
            }
            case RETRACT: {
                this.targetWingFlap2 = 0.0f;
                this.targetWingFlap = 0.0f;
                this.targetWingFold = 0.0f;
                this.targetWingExt = 0.0f;
                break;
            }
            case EXTEND: {
                this.targetWingExt = 1.0f;
                this.targetWingFold = 1.0f;
                this.targetWingFlap = 0.0f;
                this.targetWingFlap2 = 1.0f;
                break;
            }
            case EXTEND_AND_FLAP: {
                this.targetWingExt = 1.0f;
                this.targetWingFold = 1.0f;
                this.doFlapAnimation(0.08f, 2.5f, 2.0f, 0.25f, -0.5f, 2.5f);
            }
        }
    }

    private void doFlapAnimation(float flapSpeed, float upSpeed, float downSpeed, float upPitch, float downPitch, float pitchMod) {
        if (flapSpeed > 0.0f) {
            float minSpeed = Math.max(flapSpeed, 0.01f);
            this.flapAprSpeed = this.flap2AprSpeed = minSpeed * 20.0f;
            if (this.flapDir == 0.0f) {
                this.flapDir = 1.0f;
            }
            if (this.flapDir > 0.0f) {
                this.targetWingFlap = MathHelper.approachLinear((float)this.targetWingFlap, (float)10.0f, (float)(minSpeed * upSpeed));
                this.targetWingPitch = upPitch;
                if ((double)this.targetWingFlap > 0.5) {
                    this.targetWingFlap2 = 1.0f - (this.targetWingFlap - 0.5f) * 2.0f * 1.1f;
                }
                if (this.targetWingFlap >= 1.0f) {
                    this.flapDir = -1.0f;
                }
            } else {
                this.targetWingFlap = MathHelper.approachLinear((float)this.targetWingFlap, (float)-10.0f, (float)(minSpeed * downSpeed));
                this.targetWingPitch = downPitch;
                if ((double)this.targetWingFlap < 0.5) {
                    this.targetWingFlap2 = 1.0f - this.targetWingFlap * 2.0f * 1.1f;
                }
                if ((double)this.targetWingFlap <= -0.25) {
                    this.flapDir = 1.0f;
                }
            }
            this.pitchAprSpeed = minSpeed * pitchMod;
        } else {
            this.flapDir = 0.0f;
            this.targetWingPitch = 0.0f;
            this.targetWingFlap = 0.0f;
            this.targetWingFlap2 = 0.5f;
        }
    }

    public float getWingBoneCol(float partialTick) {
        return this.wingBoneCol + this.wingBoneColSpeed * partialTick;
    }

    public float getWingWebCol(float partialTick) {
        return this.wingWebCol + this.wingWebColSpeed * partialTick;
    }

    public float getShieldCol(float partialTick) {
        return this.shieldCol + this.shieldColSpeed * partialTick;
    }

    public float getWingExt(float partialTick) {
        return MathHelper.interpolate((float)this.lastWingExt, (float)this.wingExt, (float)partialTick);
    }

    public float getWingFold(float partialTick) {
        return MathHelper.interpolate((float)this.lastWingFold, (float)this.wingFold, (float)partialTick);
    }

    public float getWingFlap(float partialTick) {
        return MathHelper.interpolate((float)this.lastWingFlap, (float)this.wingFlap, (float)partialTick);
    }

    public float getWingFlap2(float partialTick) {
        return MathHelper.interpolate((float)this.lastWingFlap2, (float)this.wingFlap2, (float)partialTick);
    }

    public float getWingPitch(float partialTick) {
        return MathHelper.interpolate((float)this.lastWingPitch, (float)this.wingPitch, (float)partialTick);
    }

    public float hideDecay() {
        return Math.max(this.hideAnim - 1.0f, 0.0f);
    }
}

