/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.lucent.easygui.elements.inventory.DisplaySlot;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.complex_events.Sticky;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.util.math.BoundChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public abstract class BaseRenderable
implements ContainerRenderable,
Sticky {
    private int renderedX;
    private int renderedY;
    BoundChecker.Rec2d cullRegion;
    public Matrix4f positionTransform;
    public Matrix4f transform;
    private int x;
    private int y;
    private int visibleX;
    private int visibleY;
    public int width;
    public int height;
    public int visibleWidth;
    public int visibleHeight;
    public boolean active = true;
    public boolean visible = true;
    public boolean focused = false;
    public boolean sticky = false;
    public Action tickAction;
    public Action resizeAction;
    public Action guiChangeAction;
    private int cullBorder = 0;
    private boolean cull = false;
    public boolean useCustomScaling = true;
    private double customScale = 1.0;
    public double xRotation = 0.0;
    public double yRotation = 0.0;
    public double zRotation = 0.0;
    public IEasyGuiScreen screen;
    public ContainerRenderable parent;
    public List<ContainerRenderable> children = new ArrayList<ContainerRenderable>();
    public String id = "";
    public List<String> classList = new ArrayList<String>();

    public BaseRenderable() {
    }

    @Override
    public void setTickAction(Action action) {
        this.tickAction = action;
    }

    public BaseRenderable(IEasyGuiScreen screen) {
        this.screen = screen;
        screen.register(this);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public List<String> getClassList() {
        return List.copyOf(this.classList);
    }

    @Override
    public void setID(String id) {
        this.id = id;
        this.screen.childIdSet(this, id);
    }

    @Override
    public void addClass(String className) {
        this.classList.add(className);
        this.screen.childClassAdded(this, className);
    }

    @Override
    public void removeClass(String className) {
        this.classList.remove(className);
        this.screen.childClassRemoved(this, className);
    }

    public void setCullBorder(int cullBorder) {
        this.cullBorder = cullBorder;
    }

    public int getCullBorder() {
        return this.cullBorder;
    }

    @Override
    public void setCull(boolean cull) {
        this.cull = cull;
    }

    @Override
    public boolean shouldCull() {
        return this.cull;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public void setVisibleWidth(int visibleWidth) {
        this.visibleWidth = visibleWidth;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    public void setVisibleHeight(int visibleHeight) {
        this.visibleHeight = visibleHeight;
    }

    @Override
    public void setRotation(double x, double y, double z) {
        this.xRotation = x;
        this.yRotation = y;
        this.zRotation = z;
    }

    @Override
    public double getRotationX() {
        return this.xRotation;
    }

    @Override
    public double getRotationY() {
        return this.yRotation;
    }

    @Override
    public double getRotationZ() {
        return this.zRotation;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public double getGlobalScaledX() {
        if (this.getParent() != null) {
            return (double)this.getX() * this.getParent().getTotalScaleFactorX() + this.getParent().getGlobalScaledX();
        }
        return this.getX();
    }

    @Override
    public double getGlobalScaledY() {
        if (this.getParent() != null) {
            return (double)this.getY() * this.getParent().getTotalScaleFactorY() + this.getParent().getGlobalScaledY();
        }
        return this.getY();
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public boolean isActive() {
        if (!this.active) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        return this.parent.isActive();
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isCulled() {
        if (this.getActiveCullRegion() == null) {
            return false;
        }
        if (this.getTransform() == null) {
            return false;
        }
        Vector3f p1 = this.getTransform().transformPosition(new Vector3f(0.0f, 0.0f, 0.0f));
        Vector3f p2 = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), 0.0f, 0.0f));
        Vector3f p3 = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), (float)this.getHeight(), 0.0f));
        Vector3f p4 = this.getTransform().transformPosition(new Vector3f(0.0f, (float)this.getHeight(), 0.0f));
        if (!(this instanceof DisplaySlot)) {
            return false;
        }
        System.out.println("active cull region");
        this.getActiveCullRegion().print();
        System.out.println("this box");
        new BoundChecker.Rec2d(new BoundChecker.Vec2(p1), new BoundChecker.Vec2(p2), new BoundChecker.Vec2(p3), new BoundChecker.Vec2(p4)).print();
        return !BoundChecker.containsRec(this.getActiveCullRegion(), new BoundChecker.Rec2d(new BoundChecker.Vec2(p1), new BoundChecker.Vec2(p2), new BoundChecker.Vec2(p3), new BoundChecker.Vec2(p4)));
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public double getScale() {
        if (this.useCustomScaling) {
            return this.customScale;
        }
        return 1.0;
    }

    @Override
    public double getScaleX() {
        return this.getScale();
    }

    @Override
    public double getScaleY() {
        return this.getScale();
    }

    @Override
    public IEasyGuiScreen getScreen() {
        return this.screen;
    }

    @Override
    public void setScreen(IEasyGuiScreen screen) {
        this.screen = screen;
        screen.register(this);
    }

    @Override
    public void setRenderScale(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        this.positionTransform = new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose());
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.toRadians(this.getRotationZ())).rotateY((float)Math.toRadians(this.getRotationY())).rotateX((float)Math.toRadians(this.getRotationX()));
        guiGraphics.pose().rotateAround(rotation, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, 1.0f);
        if (this.useCustomScaling) {
            guiGraphics.pose().scale((float)this.getScaleX(), (float)this.getScaleY(), 1.0f);
        }
        this.transform = new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose());
        if (this.shouldCull()) {
            guiGraphics.enableScissor(this.getGlobalPoint().x - this.cullBorder, this.getGlobalPoint().y - this.cullBorder, this.getGlobalHeightWidthPoint().x + this.cullBorder, this.getGlobalHeightWidthPoint().y + this.cullBorder);
            this.cullRegion = new BoundChecker.Rec2d(this.getGlobalPoint(), this.getGlobalWidthPoint(), this.getGlobalHeightWidthPoint(), this.getGlobalHeightPoint());
        }
    }

    public void setCullRegion(BoundChecker.Rec2d cullRegion) {
        this.cullRegion = cullRegion;
    }

    @Override
    public int getCullBorderWidth() {
        return this.cullBorder;
    }

    @Override
    public void resetRenderScale(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
        if (this.cull) {
            guiGraphics.disableScissor();
        }
    }

    @Override
    public void renderChildren(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (ContainerRenderable child : this.getChildren()) {
            if (!child.isActive() || !child.isVisible()) continue;
            child.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public final void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        this.setRenderScale(guiGraphics);
        this.renderSelf(guiGraphics, mouseX, mouseY, partialTick);
        this.renderChildren(guiGraphics, mouseX, mouseY, partialTick);
        this.resetRenderScale(guiGraphics);
    }

    public double getMinecraftScaling() {
        return Minecraft.getInstance().getWindow().getGuiScale();
    }

    @Override
    public double getTotalCustomScaling() {
        if (this.parent != null) {
            return this.customScale * this.parent.getTotalCustomScaling();
        }
        return this.customScale;
    }

    @Override
    public double getTotalScaleFactorX() {
        if (this.parent != null && this.useCustomScaling) {
            return this.parent.getTotalScaleFactorX() * this.customScale;
        }
        if (this.parent != null) {
            return this.parent.getTotalScaleFactorX();
        }
        if (this.useCustomScaling) {
            return this.customScale;
        }
        return 1.0;
    }

    @Override
    public double getTotalScaleFactorY() {
        if (this.parent != null && this.useCustomScaling) {
            return this.parent.getTotalScaleFactorY() * this.customScale;
        }
        if (this.parent != null) {
            return this.parent.getTotalScaleFactorY();
        }
        if (this.useCustomScaling) {
            return this.customScale;
        }
        return 1.0;
    }

    @Override
    public ContainerRenderable getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public void remove() {
        this.screen.unregister(this);
        if (this.getParent() != null) {
            this.parent.getChildren().remove(this);
        }
    }

    public void setCustomScale(double customScale) {
        this.customScale = customScale;
    }

    @Override
    public void setParent(ContainerRenderable parent) {
        this.parent = parent;
    }

    @Override
    public void addChild(ContainerRenderable child) {
        System.out.println("child: " + String.valueOf(child));
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public double getCustomScale() {
        return this.customScale;
    }

    @Override
    public List<ContainerRenderable> getChildren() {
        return this.children;
    }

    @Override
    public ContainerRenderable getParent() {
        return this.parent;
    }

    @Override
    public void tick() {
        if (this.tickAction != null) {
            this.tickAction.accept(this, new Object[0]);
        }
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    @Override
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public BoundChecker.Vec2 getGlobalPoint() {
        Vector3f position = this.getTransform().transformPosition(new Vector3f(0.0f, 0.0f, 0.0f));
        return new BoundChecker.Vec2((int)position.x, (int)position.y);
    }

    public BoundChecker.Vec2 getGlobalWidthPoint() {
        Vector3f position = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), 0.0f, 0.0f));
        return new BoundChecker.Vec2((int)position.x, (int)position.y);
    }

    public BoundChecker.Vec2 getGlobalHeightPoint() {
        Vector3f position = this.getTransform().transformPosition(new Vector3f(0.0f, (float)this.getHeight(), 0.0f));
        return new BoundChecker.Vec2((int)position.x, (int)position.y);
    }

    public BoundChecker.Vec2 getGlobalHeightWidthPoint() {
        Vector3f position = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), (float)this.getHeight(), 0.0f));
        return new BoundChecker.Vec2((int)position.x, (int)position.y);
    }

    @Override
    public Matrix4f getPositionTransform() {
        return this.positionTransform;
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    public BoundChecker.Rec2d getCullRegion() {
        return this.cullRegion;
    }

    @Override
    public BoundChecker.Rec2d getActiveCullRegion() {
        if (this.cullRegion != null || this.getParent() == null) {
            return this.cullRegion;
        }
        return this.getParent().getActiveCullRegion();
    }

    @Override
    public void onResize(int oldWidth, int oldHeight, double oldScale) {
        Sticky.super.onResize(oldWidth, oldHeight, oldScale);
        if (this.resizeAction != null) {
            this.resizeAction.accept(this, oldWidth, oldHeight, oldScale);
        }
    }

    @Override
    public void onGuiScaleChanged(double oldScale) {
        Sticky.super.onGuiScaleChanged(oldScale);
        if (this.guiChangeAction != null) {
            this.guiChangeAction.accept(this, oldScale);
        }
    }

    public static abstract class Serializer {
        public int parseX(JsonElement element) {
            try {
                return element.getAsInt();
            }
            catch (Exception e) {
                return 0;
            }
        }

        public int parseY(JsonElement element) {
            return 0;
        }

        public abstract ContainerRenderable readJson(JsonObject var1);
    }
}

