/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.containers;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Window;
import java.util.function.Supplier;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.events.GuiScaleListener;
import net.lucent.easygui.interfaces.events.ScreenResizeListener;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.deserializers.BaseDeserializer;
import net.lucent.easygui.util.math.BoundChecker;
import net.lucent.easygui.util.math.Curves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class View
extends BaseRenderable
implements ScreenResizeListener,
GuiScaleListener {
    public boolean useViewportSize = false;
    public boolean useMinecraftScale = false;

    public View() {
    }

    public View(IEasyGuiScreen screen) {
        super(screen);
    }

    public View(IEasyGuiScreen screen, int x, int y) {
        this(screen, x, y, Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
    }

    public View(IEasyGuiScreen screen, int x, int y, int width, int height) {
        super(screen);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.screen = screen;
    }

    @Override
    public double getScale() {
        double finalScale = 1.0;
        if (this.useCustomScaling) {
            finalScale *= this.getCustomScale();
        }
        if (this.usesMinecraftScaling()) {
            finalScale *= Minecraft.getInstance().getWindow().getGuiScale();
        }
        return finalScale / Minecraft.getInstance().getWindow().getGuiScale();
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Curves.drawCurve(guiGraphics, new BoundChecker.Vec2(0, 0), new BoundChecker.Vec2(300, 300));
    }

    @Override
    public double getTotalScaleFactorX() {
        return this.getScaleX();
    }

    @Override
    public double getTotalScaleFactorY() {
        return this.getScaleY();
    }

    @Override
    public double getScaleX() {
        double finalScale = this.getScale();
        if (this.useViewportSize) {
            Window win = Minecraft.getInstance().getWindow();
            finalScale *= (double)win.getWidth() / (double)win.getScreenWidth();
        }
        return finalScale;
    }

    @Override
    public double getScaleY() {
        Window win = Minecraft.getInstance().getWindow();
        double finalScale = this.getScale();
        if (this.useViewportSize) {
            finalScale *= (double)win.getHeight() / (double)win.getScreenHeight();
        }
        return finalScale;
    }

    @Override
    public void remove() {
        this.screen.unregister(this);
        this.screen.removeView(this);
    }

    @Override
    public int getScaledHeight() {
        double scaleFactor = this.useCustomScaling ? this.getCustomScale() : 1.0;
        return (int)((double)this.getHeight() / scaleFactor);
    }

    @Override
    public int getScaledWidth() {
        double scaleFactor = this.useCustomScaling ? this.getCustomScale() : 1.0;
        return (int)((double)this.getWidth() / scaleFactor);
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public void onResize(int oldWidth, int oldHeight, double oldScale) {
        this.recalculateDimensions();
    }

    public void recalculateDimensions() {
        if (this.useMinecraftScale) {
            this.setWidth(Minecraft.getInstance().getWindow().getGuiScaledWidth());
            this.setHeight(Minecraft.getInstance().getWindow().getGuiScaledHeight());
        } else {
            this.setWidth(Minecraft.getInstance().getWindow().getWidth());
            this.setHeight(Minecraft.getInstance().getWindow().getHeight());
        }
    }

    @Override
    public void setCustomScale(double scale) {
        super.setCustomScale(scale);
        this.recalculateDimensions();
    }

    public void setUseMinecraftScale(boolean useMinecraftScale) {
        this.useMinecraftScale = useMinecraftScale;
        this.recalculateDimensions();
    }

    @Override
    public boolean usesMinecraftScaling() {
        return this.useMinecraftScale;
    }

    @Override
    public void onGuiScaleChanged(double oldScale) {
        this.recalculateDimensions();
    }

    public static class Deserializer
    extends BaseDeserializer {
        @Override
        public void parseWidth(String expr) {
            ((View)this.getRenderable()).recalculateDimensions();
        }

        @Override
        public void parseHeight(String expr) {
            ((View)this.getRenderable()).recalculateDimensions();
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((View)this.getRenderable()).useMinecraftScale = this.getOrDefault(obj, "use_minecraft_scaling", false);
        }

        public Deserializer(Supplier<? extends View> supplier) {
            super(supplier);
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

