/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.containers.panels;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.deserializers.BaseDeserializer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class Panel
extends SquareRenderable {
    public int borderColor = -3750202;
    public int backgroundColor = -7631989;
    public int borderWidth = 2;

    public Panel() {
    }

    public Panel(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.borderWidth != 0) {
            guiGraphics.fill(-this.borderWidth, -this.borderWidth, 0, this.getHeight() + this.borderWidth, this.borderColor);
            guiGraphics.fill(-this.borderWidth, -this.borderWidth, this.getWidth() + this.borderWidth, 0, this.borderColor);
            guiGraphics.fill(this.getWidth(), -this.borderWidth, this.getWidth() + this.borderWidth, this.getHeight() + this.borderWidth, this.borderColor);
            guiGraphics.fill(-this.borderWidth, this.getHeight(), this.getWidth() + this.borderWidth, this.getHeight() + this.borderWidth, this.borderColor);
        }
        guiGraphics.fill(0, 0, this.getWidth(), this.getHeight(), this.backgroundColor);
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public static class Deserializer
    extends BaseDeserializer {
        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            Integer backgroundColor = this.getOrDefault(obj, "background_color", -7631989);
            Integer borderColor = this.getOrDefault(obj, "border_color", -3750202);
            Integer borderWidth = this.getOrDefault(obj, "border_width", 2);
            ((Panel)this.getRenderable()).setBackgroundColor(backgroundColor);
            ((Panel)this.getRenderable()).setBorderColor(borderColor);
            ((Panel)this.getRenderable()).setBorderWidth(borderWidth);
        }

        public Deserializer(Supplier<? extends Panel> supplier) {
            super(supplier);
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

