/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.containers.scroll_boxes;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.events.Clickable;
import net.lucent.easygui.interfaces.events.MouseReleaseListener;
import net.lucent.easygui.interfaces.events.MouseScrollListener;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.templating.deserializers.SquareRenderableDeserializer;
import net.lucent.easygui.util.math.BoundChecker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractScrollBox
extends SquareRenderable
implements MouseScrollListener,
Clickable,
MouseReleaseListener {
    private int scrollBarColor = -8026747;
    private int backgroundColor = -16777216;
    private int scrollBarThickness = 4;
    private boolean scrollBarVisible = true;
    public double xOffset;
    public double yOffset;
    private int borderColor = -8026747;
    private boolean borderVisible = true;
    private int borderWidth = 1;
    public boolean dragging;
    public int draggingAxis;
    public Action clickedAction;
    public Action mouseReleasedAction;
    public Action mouseScrollAction;

    public AbstractScrollBox() {
    }

    public AbstractScrollBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.width = width;
        this.height = height;
        this.setCull(true);
    }

    public abstract double getScrollHeight();

    public abstract double getScrollWidth();

    public abstract double getScrollRate();

    @Override
    public int getWidth() {
        return this.getInnerWidth() + (this.isScrollBarYVisible() ? this.scrollBarThickness : 0);
    }

    public int getInnerWidth() {
        return this.width;
    }

    public boolean isScrollBarXVisible() {
        return this.scrollBarVisible && this.getScrollWidth() > 0.0;
    }

    public boolean isScrollBarYVisible() {
        return this.scrollBarVisible && this.getScrollHeight() > 0.0;
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.setCullBorder(width);
    }

    public void setBorderVisible(boolean visible) {
        if (!visible) {
            this.setCullBorder(0);
        } else {
            this.setCullBorder(this.borderWidth);
        }
        this.borderVisible = visible;
    }

    public void setScrollBarVisible(boolean visible) {
        this.scrollBarVisible = visible;
    }

    public int getScrollBarThickness() {
        return this.scrollBarThickness;
    }

    @Override
    public int getHeight() {
        return this.getInnerHeight() + (this.isScrollBarXVisible() ? this.scrollBarThickness : 0);
    }

    public int getInnerHeight() {
        return this.height;
    }

    public void updatePositions(double xChange, double yChange) {
        for (ContainerRenderable child : this.getChildren()) {
            child.setX((int)((double)child.getX() - xChange));
            child.setY((int)((double)child.getY() - yChange));
        }
    }

    public void setYOffset(double yOffset) {
        if (yOffset == this.yOffset) {
            return;
        }
        this.updatePositions(0.0, yOffset - this.yOffset);
        this.yOffset = yOffset;
    }

    public void setXOffset(double xOffset) {
        if (xOffset == this.xOffset) {
            return;
        }
        this.updatePositions(xOffset - this.xOffset, 0.0);
        this.xOffset = xOffset;
    }

    public static double getScrollAmount(double scrollAmount, double scrollDelta, double maxScrollAmount) {
        return Mth.clamp((double)(scrollAmount + scrollDelta), (double)0.0, (double)maxScrollAmount);
    }

    @Override
    public void onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setYOffset(AbstractScrollBox.getScrollAmount(this.yOffset, -scrollY * this.getScrollRate(), this.getScrollHeight()));
        }
        if (this.mouseScrollAction != null) {
            this.mouseScrollAction.accept(this, mouseX, mouseY, scrollX, scrollY);
        }
    }

    private int getScrollBarHeight() {
        return Mth.clamp((int)((int)((double)(this.getInnerHeight() * this.getInnerHeight()) / ((double)this.getInnerHeight() + this.getScrollHeight()))), (int)32, (int)this.getInnerHeight());
    }

    private int getScrollBarWidth() {
        return Mth.clamp((int)((int)((double)(this.getInnerWidth() * this.getInnerWidth()) / ((double)this.getInnerWidth() + this.getScrollWidth()))), (int)32, (int)this.getInnerHeight());
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.borderVisible) {
            guiGraphics.fill(-this.borderWidth, -this.borderWidth, this.getWidth() + this.borderWidth, this.getHeight() + this.borderWidth, this.borderColor);
        }
        guiGraphics.fill(0, 0, this.getWidth(), this.getHeight(), this.backgroundColor);
    }

    @Override
    public void renderChildren(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderChildren(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollBar(guiGraphics);
    }

    public void renderScrollBar(GuiGraphics guiGraphics) {
        double progress;
        if (this.isScrollBarYVisible()) {
            double height = this.getScrollBarHeight();
            progress = ((double)this.getInnerHeight() - height) * (this.yOffset / this.getScrollHeight());
            double width = this.getScrollBarThickness();
            guiGraphics.fill(this.getInnerWidth(), (int)progress, (int)((double)this.getInnerWidth() + width), (int)(progress + height), this.scrollBarColor);
        }
        if (this.isScrollBarXVisible()) {
            double width = this.getScrollBarWidth();
            progress = ((double)this.getInnerWidth() - width) * (this.xOffset / this.getScrollWidth());
            double height = this.getScrollBarThickness();
            guiGraphics.fill((int)progress, this.getInnerHeight(), (int)(progress + width), (int)((double)this.getInnerHeight() + height), this.scrollBarColor);
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (clicked) {
            BoundChecker.Vec2 point = this.screenToLocalPoint(mouseX, mouseY);
            if (point.x > this.getInnerWidth()) {
                this.dragging = true;
                this.draggingAxis = 0;
                double progress = this.getScrollHeight() * ((double)point.y / (double)this.getInnerHeight());
                this.setYOffset(AbstractScrollBox.getScrollAmount(progress, 0.0, this.getScrollHeight()));
            } else if (point.y > this.getInnerHeight()) {
                this.dragging = true;
                this.draggingAxis = 1;
                double progress = this.getScrollWidth() * ((double)point.x / (double)this.getInnerWidth());
                this.setXOffset(AbstractScrollBox.getScrollAmount(progress, 0.0, this.getScrollWidth()));
            }
        }
        if (this.clickedAction != null) {
            this.clickedAction.accept(this, mouseX, mouseY, button, clicked);
        }
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
        }
        if (this.mouseReleasedAction != null) {
            this.mouseReleasedAction.accept(this, mouseX, mouseY, button);
        }
    }

    public void setScrollBarColor(int scrollBarColor) {
        this.scrollBarColor = scrollBarColor;
    }

    public void setScrollBarThickness(int scrollBarThickness) {
        this.scrollBarThickness = scrollBarThickness;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public static class Deserializer
    extends SquareRenderableDeserializer {
        public Deserializer(Supplier<? extends AbstractScrollBox> supplier) {
            super((Supplier<? extends SquareRenderable>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((AbstractScrollBox)this.getRenderable()).setBackgroundColor(this.getOrDefault(obj, "background_color", -16777216));
            ((AbstractScrollBox)this.getRenderable()).setScrollBarColor(this.getOrDefault(obj, "scroll_bar_color", -8026747));
            ((AbstractScrollBox)this.getRenderable()).setScrollBarThickness(this.getOrDefault(obj, "scroll_bar_width", 2));
            ((AbstractScrollBox)this.getRenderable()).setScrollBarVisible(this.getOrDefault(obj, "scroll_bar_visible", true));
            ((AbstractScrollBox)this.getRenderable()).setBorderColor(this.getOrDefault(obj, "border_color", -8026747));
            ((AbstractScrollBox)this.getRenderable()).setBorderWidth(this.getOrDefault(obj, "border_width", 1));
            ((AbstractScrollBox)this.getRenderable()).setBorderVisible(this.getOrDefault(obj, "border_visible", true));
            this.getRenderable().setCull(this.getOrDefault(obj, "cull", true));
            ((AbstractScrollBox)this.getRenderable()).clickedAction = this.parseAction("on_click", obj);
            ((AbstractScrollBox)this.getRenderable()).mouseReleasedAction = this.parseAction("on_click_release", obj);
            ((AbstractScrollBox)this.getRenderable()).mouseScrollAction = this.parseAction("on_scroll", obj);
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

