/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.containers.scroll_boxes;

import net.lucent.easygui.elements.containers.scroll_boxes.AbstractScrollBox;
import net.lucent.easygui.elements.inventory.DisplaySlot;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.world.Container;

public class ContainerScrollBox
extends AbstractScrollBox {
    public int slots;
    public int rows;
    public int displayRows;

    public ContainerScrollBox(IEasyGuiScreen screen, int x, int y, int slots, int slotsPerRow, int displayRows, Container container) {
        super(screen, x, y, 0, 0);
        this.setWidth(slotsPerRow * 18);
        this.generateSlots(slots, container);
        this.setScrollBarVisible(false);
        this.setHeight(displayRows * 18);
        this.rows = slots / slotsPerRow + 1;
        this.displayRows = displayRows;
    }

    public void generateSlots(int slots, Container container) {
        int slotsPerRow = this.width / 18;
        this.setHeight(this.rows * 18);
        for (int i = 0; i < slots; ++i) {
            int row = i / slotsPerRow;
            int column = i % slotsPerRow;
            System.out.println("row: " + row);
            DisplaySlot slot = new DisplaySlot(this.getScreen(), column * 18 + 1, row * 18 + 1, 16, 16, i, container);
            this.addChild(slot);
        }
    }

    @Override
    public void onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setYOffset(ContainerScrollBox.getScrollAmount(this.yOffset, -scrollY * 18.0, this.getScrollHeight()));
        }
        System.out.println(this.yOffset);
        if (this.mouseScrollAction != null) {
            this.mouseScrollAction.accept(this, mouseX, mouseY, scrollX, scrollY);
        }
    }

    @Override
    public double getScrollHeight() {
        return Math.max(0, (this.rows - this.displayRows - 1) * 18);
    }

    @Override
    public double getScrollWidth() {
        return 0.0;
    }

    @Override
    public double getScrollRate() {
        return 0.0;
    }
}

