/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.containers.scroll_boxes;

import net.lucent.easygui.elements.containers.scroll_boxes.AbstractScrollBox;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;

public class DynamicScrollBox
extends AbstractScrollBox {
    private double maxScrollY;
    private double maxScrollX;

    public DynamicScrollBox() {
    }

    public DynamicScrollBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen, x, y, width, height);
    }

    @Override
    public double getScrollHeight() {
        return this.maxScrollY;
    }

    @Override
    public void addChild(ContainerRenderable child) {
        super.addChild(child);
        if ((double)(child.getY() + child.getHeight()) > this.getScrollHeight()) {
            this.maxScrollY = Math.max(0, child.getY() + child.getHeight() - this.getInnerHeight());
        }
        if ((double)(child.getX() + this.getWidth()) > this.getScrollWidth()) {
            this.maxScrollX = Math.max(0, child.getX() + child.getWidth() - this.getInnerWidth());
        }
    }

    @Override
    public double getScrollWidth() {
        return this.maxScrollX;
    }

    @Override
    public double getScrollRate() {
        return 9.0;
    }
}

