/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.containers.scroll_boxes;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.containers.scroll_boxes.AbstractScrollBox;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.templating.IRenderableDeserializer;
import org.jetbrains.annotations.NotNull;

public class FixedSizedScrollBox
extends AbstractScrollBox {
    public double scrollHeight;
    public double scrollWidth;

    public FixedSizedScrollBox() {
    }

    public FixedSizedScrollBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen, x, y, width, height);
    }

    @Override
    public double getScrollHeight() {
        return this.scrollHeight;
    }

    @Override
    public double getScrollWidth() {
        return this.scrollWidth;
    }

    @Override
    public double getScrollRate() {
        return 9.0;
    }

    public void setScrollWidth(double scrollWidth) {
        this.scrollWidth = scrollWidth;
    }

    public void setScrollHeight(double scrollHeight) {
        this.scrollHeight = scrollHeight;
    }

    public static class Deserializer
    extends AbstractScrollBox.Deserializer {
        public Deserializer(Supplier<? extends FixedSizedScrollBox> supplier) {
            super((Supplier<? extends AbstractScrollBox>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((FixedSizedScrollBox)this.getRenderable()).setScrollHeight(this.getOrDefault(obj, "scroll_height", 0.0));
            ((FixedSizedScrollBox)this.getRenderable()).setScrollWidth(this.getOrDefault(obj, "scroll_width", 0.0));
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

