/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.buttons;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.complex_events.Sticky;
import net.lucent.easygui.interfaces.events.Clickable;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.templating.deserializers.SquareRenderableDeserializer;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractButton
extends SquareRenderable
implements Clickable,
Sticky {
    public int PRESSED_TIME = 10;
    public double time_pressed = 0.0;
    public boolean unPressNaturally = true;
    public boolean sticky = false;
    public boolean pressed;
    public boolean hovered;
    public Action clickAction;

    public AbstractButton() {
    }

    public AbstractButton(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    @Override
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setPressed(boolean state) {
        this.pressed = state;
    }

    public void setHovered(boolean state) {
        this.hovered = state;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (clicked) {
            this.setPressed(true);
            this.time_pressed = 0.0;
        }
        if (this.clickAction != null) {
            this.clickAction.accept(this, mouseX, mouseY, button, clicked);
        }
    }

    @Override
    public void onMouseOver(boolean state) {
        this.setHovered(state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.unPressNaturally) {
            this.time_pressed += 1.0;
            if (this.time_pressed >= (double)this.PRESSED_TIME) {
                this.setPressed(false);
                this.time_pressed = 0.0;
            }
        }
    }

    public void setPressTime(int pressTime) {
        this.PRESSED_TIME = pressTime;
    }

    public static class Deserializer
    extends SquareRenderableDeserializer {
        public Deserializer(Supplier<? extends AbstractButton> supplier) {
            super((Supplier<? extends SquareRenderable>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((AbstractButton)this.getRenderable()).setPressTime(this.getOrDefault(obj, "press_time", 10));
            if (obj.getAsJsonObject("on_click") != null) {
                System.out.println(obj.getAsJsonObject("on_click"));
                ((AbstractButton)this.getRenderable()).clickAction = this.parseAction("on_click", obj);
            }
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

