/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.buttons;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.controls.buttons.AbstractButton;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class ColorButton
extends AbstractButton {
    private int defaultColor = -6118750;
    private int hoverColor = -4013374;
    private int pressColor = -7829368;
    private int focusColor = -6118750;

    public ColorButton() {
    }

    public ColorButton(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height) {
        super(easyGuiScreen, x, y, width, height);
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int finalColor = this.defaultColor;
        if (this.focused) {
            finalColor = this.focusColor;
            guiGraphics.fill(-1, -1, this.getWidth() + 2, this.getHeight() + 2, -1);
        }
        if (this.hovered) {
            finalColor = this.hoverColor;
        }
        if (this.pressed) {
            finalColor = this.pressColor;
        }
        guiGraphics.fill(0, 0, this.getWidth(), this.getHeight(), finalColor);
    }

    public void setDefaultColor(int color) {
        this.defaultColor = color;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }

    public void setFocusColor(int focusColor) {
        this.focusColor = focusColor;
    }

    public void setPressColor(int pressColor) {
        this.pressColor = pressColor;
    }

    public static class Deserializer
    extends AbstractButton.Deserializer {
        public Deserializer(Supplier<? extends ColorButton> supplier) {
            super((Supplier<? extends AbstractButton>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((ColorButton)this.getRenderable()).setDefaultColor(this.getOrDefault(obj, "default_color", -6118750));
            ((ColorButton)this.getRenderable()).setHoverColor(this.getOrDefault(obj, "hovered_color", -4013374));
            ((ColorButton)this.getRenderable()).setPressColor(this.getOrDefault(obj, "pressed_color", -7829368));
            ((ColorButton)this.getRenderable()).setFocusColor(this.getOrDefault(obj, "focused_color", -6118750));
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

