/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.buttons;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.controls.buttons.AbstractButton;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class TextureButton
extends AbstractButton {
    public ITextureData defaultTexture;
    public ITextureData pressedTexture;
    public ITextureData hoveredTexture;
    public ITextureData focusedTexture;

    public TextureButton() {
    }

    public TextureButton(IEasyGuiScreen easyGuiScreen, int x, int y, ITextureData defaultTexture, ITextureData pressedTexture, ITextureData hoveredTexture, ITextureData focusedTexture) {
        super(easyGuiScreen, x, y, defaultTexture.getWidth(), defaultTexture.getHeight());
        this.defaultTexture = defaultTexture;
        this.pressedTexture = pressedTexture;
        this.hoveredTexture = hoveredTexture;
        this.focusedTexture = focusedTexture;
    }

    public TextureButton(IEasyGuiScreen easyGuiScreen, int x, int y, ITextureData defaultTexture, ITextureData pressedTexture, ITextureData hoveredTexture) {
        this(easyGuiScreen, x, y, defaultTexture, pressedTexture, hoveredTexture, defaultTexture);
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ITextureData finalTexture = this.defaultTexture;
        if (this.isFocused()) {
            finalTexture = this.focusedTexture;
        }
        if (this.isHovered()) {
            finalTexture = this.hoveredTexture;
        }
        if (this.isPressed()) {
            finalTexture = this.pressedTexture;
        }
        finalTexture.renderTexture(guiGraphics, this.getX(), this.getY());
    }

    public void setDefaultTexture(ITextureData defaultTexture) {
        this.defaultTexture = defaultTexture;
    }

    public void setHoveredTexture(ITextureData hoveredTexture) {
        this.hoveredTexture = hoveredTexture;
    }

    public void setPressedTexture(ITextureData pressedTexture) {
        this.pressedTexture = pressedTexture;
    }

    public void setFocusedTexture(ITextureData focusedTexture) {
        this.focusedTexture = focusedTexture;
    }

    public static class Deserializer
    extends AbstractButton.Deserializer {
        public Deserializer(Supplier<? extends TextureButton> supplier) {
            super((Supplier<? extends AbstractButton>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((TextureButton)this.getRenderable()).setDefaultTexture(this.parseTexture("default_texture", obj));
            ((TextureButton)this.getRenderable()).setHoveredTexture(this.parseTexture("hovered_texture", obj));
            ((TextureButton)this.getRenderable()).setPressedTexture(this.parseTexture("pressed_texture", obj));
            ITextureData data = this.parseTexture("focused_texture", obj);
            if (data == null) {
                data = this.parseTexture("default_texture", obj);
            }
            ((TextureButton)this.getRenderable()).setFocusedTexture(data);
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

