/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.buttons;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.controls.buttons.AbstractButton;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.util.textures.TextureData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ToggleButton
extends AbstractButton {
    private ITextureData backgroundTexture = new TextureData(ResourceLocation.fromNamespaceAndPath((String)"easy_gui", (String)"built_in_textures/check_box_background.png"), 32, 32);
    private ITextureData onStateTexture = new TextureData(ResourceLocation.fromNamespaceAndPath((String)"easy_gui", (String)"built_in_textures/check_box_tick.png"), 32, 32);
    private ITextureData offStateTexture = new TextureData(ResourceLocation.fromNamespaceAndPath((String)"easy_gui", (String)"built_in_textures/check_box_x.png"), 32, 32);

    public ToggleButton() {
    }

    public ToggleButton(IEasyGuiScreen easyGuiScreen, int x, int y) {
        super(easyGuiScreen, x, y, 0, 0);
        this.unPressNaturally = false;
    }

    public void setBackgroundTexture(ITextureData backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
    }

    public void setOnStateTexture(ITextureData on) {
        if (on == null) {
            this.onStateTexture = new TextureData(ResourceLocation.fromNamespaceAndPath((String)"easy_gui", (String)"built_in_textures/check_box_tick.png"), 32, 32);
            return;
        }
        this.onStateTexture = on;
    }

    public void setOffStateTexture(ITextureData off) {
        if (off == null) {
            this.offStateTexture = new TextureData(ResourceLocation.fromNamespaceAndPath((String)"easy_gui", (String)"built_in_textures/check_box_x.png"), 32, 32);
            return;
        }
        this.offStateTexture = off;
    }

    @Override
    public int getWidth() {
        return this.backgroundTexture.getTextureWidth();
    }

    @Override
    public int getHeight() {
        return this.backgroundTexture.getTextureHeight();
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.backgroundTexture != null) {
            this.backgroundTexture.renderTexture(guiGraphics);
        }
        if (this.isPressed()) {
            this.onStateTexture.renderTexture(guiGraphics);
        } else {
            this.offStateTexture.renderTexture(guiGraphics);
        }
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (clicked && button == 0) {
            this.setPressed(!this.isPressed());
        }
    }

    public boolean getState() {
        return this.isPressed();
    }

    public static class Deserializer
    extends AbstractButton.Deserializer {
        public Deserializer(Supplier<? extends ToggleButton> supplier) {
            super((Supplier<? extends AbstractButton>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((ToggleButton)this.getRenderable()).setBackgroundTexture(this.parseTexture("background_texture", obj));
            ((ToggleButton)this.getRenderable()).setOnStateTexture(this.parseTexture("on_texture", obj));
            ((ToggleButton)this.getRenderable()).setOffStateTexture(this.parseTexture("off_texture", obj));
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

