/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.inputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.events.Clickable;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.templating.deserializers.SquareRenderableDeserializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ComboBox
extends SquareRenderable
implements Clickable {
    public int borderColor = -16777216;
    public int textColor = -16777216;
    public int backgroundColor = -1;
    public int hoverColor = -6250336;
    public int borderWidth = 1;
    private final List<String> entries = new ArrayList<String>();
    public Font font;
    public Action valueChangedAction;
    public Action clickAction;
    int selectedIndex;
    Consumer<String> consumer;
    boolean hovered;

    public ComboBox() {
        this.font = Minecraft.getInstance().font;
        this.selectedIndex = 0;
        this.hovered = false;
    }

    public ComboBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width, int height, Consumer<String> valueChanged) {
        super(easyGuiScreen);
        this.font = Minecraft.getInstance().font;
        this.selectedIndex = 0;
        this.hovered = false;
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.consumer = valueChanged;
    }

    @Override
    public int getHeight() {
        if (!this.isFocused()) {
            return super.getHeight();
        }
        return this.height + this.height * this.entries.size();
    }

    public void setValue(int index) {
        this.selectedIndex = index;
    }

    public String getSelectedValue() {
        return this.entries.get(this.selectedIndex);
    }

    public void addValue(String value) {
        this.entries.add(value);
    }

    public void addValues(List<String> values) {
        this.entries.addAll(values);
    }

    public List<String> getValues() {
        return List.copyOf(this.entries);
    }

    public String getValue(int index) {
        return this.entries.get(index);
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double y;
        guiGraphics.fill(0, 0, this.getWidth(), this.height, this.backgroundColor);
        Vector3f cullPos = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), (float)this.height, 0.0f));
        guiGraphics.enableScissor(this.getGlobalPoint().x, this.getGlobalPoint().y, this.getGlobalHeightWidthPoint().x, (int)cullPos.y);
        String string = this.getValue(this.selectedIndex);
        int n = this.height / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, string, 0, n - 9 / 2, this.textColor, false);
        guiGraphics.disableScissor();
        int hoveredIndex = -1;
        if (this.hovered && (y = (double)this.screenToLocalPoint((double)((double)mouseX), (double)((double)mouseY)).y) > (double)this.height) {
            hoveredIndex = (int)Math.floor((y - (double)this.height) / (double)this.height);
        }
        if (this.isFocused()) {
            for (int i = 0; i < this.entries.size(); ++i) {
                int renderColor = this.backgroundColor;
                if (i == hoveredIndex) {
                    renderColor = this.hoverColor;
                }
                boolean x = false;
                int y2 = this.height + i * this.height;
                Vector3f pos = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), (float)(this.height + i * this.height), 0.0f));
                Vector3f pos2 = this.getTransform().transformPosition(new Vector3f((float)this.getWidth(), (float)(2 * this.height + i * this.height), 0.0f));
                guiGraphics.fill(0, y2, this.getWidth(), 2 * this.height + i * this.height, renderColor);
                guiGraphics.enableScissor(this.getGlobalPoint().x, (int)pos.y, this.getGlobalPoint().x + this.getWidth(), (int)pos2.y);
                String string2 = this.getValue(i);
                int n2 = y2 + this.height / 2;
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, string2, 0, n2 - 9 / 2, this.textColor, false);
                guiGraphics.disableScissor();
                guiGraphics.fill(-this.borderWidth, -this.borderWidth + y2, this.getWidth() + this.borderWidth, y2, this.borderColor);
                guiGraphics.fill(this.getWidth(), -this.borderWidth + y2, this.getWidth() + this.borderWidth, y2 + this.height + this.borderWidth, this.borderColor);
            }
        }
        if (this.borderWidth != 0) {
            guiGraphics.fill(-this.borderWidth, -this.borderWidth, 0, this.height + this.borderWidth, this.borderColor);
            guiGraphics.fill(-this.borderWidth, -this.borderWidth, this.getWidth() + this.borderWidth, 0, this.borderColor);
            guiGraphics.fill(this.getWidth(), -this.borderWidth, this.getWidth() + this.borderWidth, this.height + this.borderWidth, this.borderColor);
            guiGraphics.fill(-this.borderWidth, this.height, this.getWidth() + this.borderWidth, this.height + this.borderWidth, this.borderColor);
        }
    }

    @Override
    public void onMouseOver(boolean state) {
        super.onMouseOver(state);
        this.hovered = state;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (!this.focused && clicked) {
            this.setFocused(true);
        } else if (clicked) {
            int index;
            double y = this.screenToLocalPoint((double)mouseX, (double)mouseY).y;
            if (y > (double)this.height && (index = (int)Math.floor((y - (double)this.height) / (double)this.height)) != this.selectedIndex) {
                this.setValue(index);
                if (this.consumer != null) {
                    this.consumer.accept(this.getValue(index));
                }
                if (this.valueChangedAction != null) {
                    this.valueChangedAction.accept(this, new Object[0]);
                }
            }
            this.setFocused(false);
        } else {
            this.setFocused(false);
        }
        if (this.clickAction != null) {
            this.clickAction.accept(this, mouseX, mouseY, button, clicked);
        }
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }

    public static class Deserializer
    extends SquareRenderableDeserializer {
        public Deserializer(Supplier<? extends ComboBox> supplier) {
            super((Supplier<? extends SquareRenderable>)supplier);
        }

        public void parseStringList(String key, JsonObject obj) {
            if (obj.getAsJsonArray(key) == null) {
                this.throwMissingField("expected field entries for combo box");
            }
            JsonArray entries = obj.getAsJsonArray(key);
            System.out.println("parsing String list");
            for (JsonElement entry : entries) {
                ((ComboBox)this.getRenderable()).addValue(entry.getAsString());
            }
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            Integer backgroundColor = this.getOrDefault(obj, "background_color", -1);
            Integer borderColor = this.getOrDefault(obj, "border_color", -16777216);
            Integer borderWidth = this.getOrDefault(obj, "border_width", 1);
            ((ComboBox)this.getRenderable()).setBackgroundColor(backgroundColor);
            ((ComboBox)this.getRenderable()).setBorderColor(borderColor);
            ((ComboBox)this.getRenderable()).setBorderWidth(borderWidth);
            ((ComboBox)this.getRenderable()).textColor = this.getOrDefault(obj, "text_color", -16777216);
            ((ComboBox)this.getRenderable()).setHoverColor(this.getOrDefault(obj, "hovered_color", -6250336));
            this.parseStringList("entries", obj);
            ((ComboBox)this.getRenderable()).setValue(this.getOrDefault(obj, "default_entry", 0));
            ((ComboBox)this.getRenderable()).clickAction = this.parseAction("on_click", obj);
            ((ComboBox)this.getRenderable()).valueChangedAction = this.parseAction("on_value_changed", obj);
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

