/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.controls.inputs;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lucent.easygui.elements.controls.inputs.EnhancedEditBox;
import net.lucent.easygui.elements.other.SquareRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.complex_events.Draggable;
import net.lucent.easygui.interfaces.events.CharTypedListener;
import net.lucent.easygui.interfaces.events.KeyPressedListener;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.templating.deserializers.SquareRenderableDeserializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class TextBox
extends SquareRenderable
implements Draggable,
CharTypedListener,
KeyPressedListener {
    private boolean editable = false;
    private final EnhancedEditBox editBox;
    private final Font font;
    private boolean dragging;
    private int draggingX;
    private Component hint;
    public Action charTypedAction;
    public Action keyPressedAction;
    public Action mouseDraggedAction;
    public Action clickedAction;
    public Action mouseReleasedAction;

    public TextBox() {
        this.font = Minecraft.getInstance().font;
        this.hint = null;
        Objects.requireNonNull(this.font);
        this.editBox = new EnhancedEditBox(this.font, 0, 9 + 2, (Component)Component.empty());
        this.editBox.parent = this;
    }

    public TextBox(IEasyGuiScreen easyGuiScreen, int x, int y, int width) {
        super(easyGuiScreen);
        this.font = Minecraft.getInstance().font;
        this.hint = null;
        this.setX(x);
        this.setY(y);
        Objects.requireNonNull(this.font);
        this.editBox = new EnhancedEditBox(this.font, width, 9 + 2, (Component)Component.empty());
        this.editBox.parent = this;
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        this.editBox.setWidth(width);
    }

    @Override
    public int getWidth() {
        return this.editBox.getWidth();
    }

    @Override
    public int getHeight() {
        return this.editBox.getHeight();
    }

    public void setHint(Component hint) {
        this.hint = hint;
    }

    public void setEditable(boolean editable) {
        this.editBox.setEditable(editable);
        this.editable = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setPivot(int pivotX) {
        this.draggingX = pivotX;
    }

    @Override
    public boolean isDragged() {
        return this.dragging;
    }

    @Override
    public void setDragged(boolean state) {
        this.dragging = state;
    }

    @Override
    public void setClickPosition(double mouseX, double mouseY) {
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (!clicked) {
            this.setEditable(false);
            this.setFocused(false);
        } else {
            if (this.isFocused()) {
                this.editBox.enhancedOnClick(mouseX, mouseY, button, (int)this.getGlobalScaledX(), this.getTotalScaleFactorX());
            } else {
                this.setEditable(true);
                this.setFocused(true);
            }
            if (clicked && button == 0) {
                this.setDragged(true);
                this.setPivot((int)(((double)Mth.floor((double)mouseX) - this.getGlobalScaledX()) / this.getTotalScaleFactorX()));
            }
        }
        if (this.clickedAction != null) {
            this.clickedAction.accept(this, mouseX, mouseY, button, clicked);
        }
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.setDragged(false);
            this.setPivot(0);
        }
        if (this.mouseReleasedAction != null) {
            this.mouseReleasedAction.accept(this, mouseX, mouseY, button);
        }
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (focused != this.editBox.isFocused()) {
            this.editBox.setFocused(focused);
        }
    }

    public String getValue() {
        return this.editBox.getValue();
    }

    public void setValue(String value) {
        this.editBox.setValue(value);
    }

    public void setValueWithoutNotification(String value) {
        Consumer temp = this.editBox.responder;
        this.editBox.setResponder(null);
        this.editBox.setValue(value);
        this.editBox.setResponder(temp);
    }

    public void setTextColor(int color) {
        this.editBox.setTextColor(color);
    }

    public void setTextColorUneditable(int color) {
        this.editBox.setTextColorUneditable(color);
    }

    public void setBordered(boolean bordered) {
        this.editBox.setBordered(bordered);
        if (!bordered) {
            this.editBox.setX(this.getX() + 1);
            this.editBox.setY(this.getY() + 1);
            this.editBox.setWidth(this.getWidth() - 6);
        } else {
            this.editBox.setX(this.getX());
            this.editBox.setY(this.getY());
            this.editBox.setWidth(this.getWidth());
        }
    }

    public void setResponder(Consumer<String> responder) {
        this.editBox.setResponder(responder);
    }

    public void setMaxLength(int length) {
        this.editBox.setMaxLength(length);
    }

    @Override
    public void onCharTyped(char codePoint, int modifiers) {
        this.editBox.charTyped(codePoint, modifiers);
        if (this.charTypedAction != null) {
            this.charTypedAction.accept(this, Character.valueOf(codePoint), modifiers);
        }
    }

    @Override
    public void onKeyPressed(int keyCode, int scanCode, int modifier) {
        if (this.isFocused()) {
            this.editBox.keyPressed(keyCode, scanCode, modifier);
            if (keyCode == 257) {
                this.onEnter();
            }
        }
        if (this.keyPressedAction != null) {
            this.keyPressedAction.accept(this, keyCode, scanCode, modifier);
        }
    }

    public void onEnter() {
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.editBox.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (this.editBox.getValue().isEmpty() && this.hint != null && !this.editBox.isFocused()) {
            guiGraphics.drawCenteredString(this.font, this.hint, this.getWidth() / 2, this.getHeight() / 2, this.editBox.textColor);
        }
    }

    @Override
    public void onDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        int distance = (int)(((double)Mth.floor((double)mouseX) - this.getGlobalScaledX()) / this.getTotalScaleFactorX());
        this.editBox.highlightSubstring(distance);
        if (this.mouseDraggedAction != null) {
            this.mouseDraggedAction.accept(this, mouseX, mouseY, button, dragX, dragY);
        }
    }

    public static class Deserializer
    extends SquareRenderableDeserializer {
        @Override
        public void parseHeight(String expr) {
        }

        public Deserializer(Supplier<? extends TextBox> supplier) {
            super((Supplier<? extends SquareRenderable>)supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((TextBox)this.getRenderable()).setHint(this.parseComponent("hint", obj));
            ((TextBox)this.getRenderable()).clickedAction = this.parseAction("on_click", obj);
            ((TextBox)this.getRenderable()).mouseReleasedAction = this.parseAction("on_click_release", obj);
            ((TextBox)this.getRenderable()).mouseDraggedAction = this.parseAction("on_mouse_drag", obj);
            ((TextBox)this.getRenderable()).charTypedAction = this.parseAction("on_char_typed", obj);
            ((TextBox)this.getRenderable()).keyPressedAction = this.parseAction("on_key_pressed", obj);
            ((TextBox)this.getRenderable()).editBox.valueChangedAction = this.parseAction("on_value_changed", obj);
            ((TextBox)this.getRenderable()).setTextColor(this.getOrDefault(obj, "text_color", 0xE0E0E0));
            ((TextBox)this.getRenderable()).setTextColorUneditable(this.getOrDefault(obj, "unfocused_text_color", 0x707070));
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

