/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.inventory;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.math.Axis;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.screens.EasyGuiScreen;
import net.lucent.easygui.util.math.BoundChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class DisplayEntity
extends BaseRenderable {
    public LivingEntity entity;
    public double entityScale;

    public DisplayEntity(EasyGuiScreen easyGuiScreen, LivingEntity entity, int x, int y, double entityScale) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.setWidth((int)((double)entity.getBbWidth() * entityScale));
        this.setHeight((int)((double)entity.getBbHeight() * entityScale));
        System.out.println(this.getWidth());
        System.out.println(this.getHeight());
        this.entity = entity;
        this.entityScale = entityScale;
    }

    @Override
    public void setRenderScale(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)this.getX(), (double)this.getY() + (double)this.entity.getBbHeight() * this.entityScale / 2.0, 0.0);
        this.positionTransform = new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose());
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.toRadians(this.getRotationZ())).rotateY((float)Math.toRadians(this.getRotationY())).rotateX((float)Math.toRadians(this.getRotationX()));
        guiGraphics.pose().rotateAround(rotation, 0.0f, (float)(-((double)this.entity.getBbHeight() * this.entityScale / 2.0)), 1.0f);
        if (this.useCustomScaling) {
            guiGraphics.pose().scale((float)this.getScaleX(), (float)this.getScaleY(), 1.0f);
        }
        this.transform = new Matrix4f((Matrix4fc)guiGraphics.pose().last().pose());
        if (this.shouldCull()) {
            guiGraphics.enableScissor(this.getGlobalPoint().x - this.getCullBorderWidth(), this.getGlobalPoint().y - this.getCullBorderWidth(), this.getGlobalHeightWidthPoint().x + this.getCullBorderWidth(), this.getGlobalHeightWidthPoint().y + this.getCullBorderWidth());
            this.setCullRegion(new BoundChecker.Rec2d(this.getGlobalPoint(), this.getGlobalWidthPoint(), this.getGlobalHeightWidthPoint(), this.getGlobalHeightPoint()));
        }
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.entity != null) {
            Lighting.setupForEntityInInventory();
            EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            int lightLevel = 0xF000F0;
            float f4 = this.entity.yBodyRot;
            float f5 = this.entity.getYRot();
            float f6 = this.entity.getXRot();
            float f7 = this.entity.yHeadRotO;
            float f8 = this.entity.yHeadRot;
            this.entity.yBodyRot = 180.0f;
            this.entity.setYRot(180.0f);
            this.entity.setXRot(0.0f);
            this.entity.yHeadRot = this.entity.getYRot();
            this.entity.yHeadRotO = this.entity.getYRot();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(this.entity.getBbWidth() / 2.0f, this.entity.getBbHeight() / 2.0f, 0.0f);
            guiGraphics.pose().scale((float)this.entityScale, (float)this.entityScale, (float)this.entityScale);
            entityrenderdispatcher.setRenderShadow(false);
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
            entityrenderdispatcher.render((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), lightLevel);
            guiGraphics.bufferSource().endBatch();
            guiGraphics.flush();
            entityrenderdispatcher.setRenderShadow(true);
            guiGraphics.pose().popPose();
            Lighting.setupFor3DItems();
            this.entity.yBodyRot = f4;
            this.entity.setYRot(f5);
            this.entity.setXRot(f6);
            this.entity.yHeadRotO = f7;
            this.entity.yHeadRot = f8;
        }
    }
}

