/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.other;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.deserializers.BaseDeserializer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class Image
extends BaseRenderable {
    private ITextureData textureData;

    public Image(IEasyGuiScreen easyGuiScreen, ITextureData textureData, int x, int y) {
        super(easyGuiScreen);
        this.textureData = textureData;
        this.setX(x);
        this.setY(y);
    }

    @Override
    public int getHeight() {
        if (this.textureData == null) {
            return 0;
        }
        return this.textureData.getHeight();
    }

    @Override
    public int getWidth() {
        if (this.textureData == null) {
            return 0;
        }
        return this.textureData.getWidth();
    }

    public Image() {
    }

    public ITextureData getTextureData() {
        return this.textureData;
    }

    public void setTextureData(ITextureData textureData) {
        this.textureData = textureData;
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.textureData.renderTexture(guiGraphics, this.getX(), this.getY());
    }

    public static class Deserializer
    extends BaseDeserializer {
        @Override
        public void parseWidth(String expr) {
        }

        @Override
        public void parseHeight(String expr) {
        }

        public Deserializer(Supplier<? extends Image> supplier) {
            super(supplier);
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((Image)this.getRenderable()).setTextureData(this.parseTexture("texture", obj));
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

