/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.other;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Supplier;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.deserializers.BaseDeserializer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class Label
extends BaseRenderable {
    public int textColor;
    public boolean centered;
    public Component text;
    public Font font;

    public Label() {
        this.font = Minecraft.getInstance().font;
    }

    private Label(IEasyGuiScreen easyGuiScreen, Font font, Component text, int x, int y, int width, int height, boolean centered, int textColor) {
        super(easyGuiScreen);
        this.font = Minecraft.getInstance().font;
        this.font = font;
        this.text = text;
        this.setY(y);
        this.setX(x);
        this.setWidth(width);
        this.setHeight(height);
        this.centered = centered;
        this.textColor = textColor;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.centered) {
            guiGraphics.pose().translate((float)(-this.getWidth()) / 2.0f, (float)(-this.getHeight()) / 2.0f, 0.0f);
        }
        guiGraphics.drawWordWrap(this.getFont(), (FormattedText)this.text, 0, 0, this.getWidth(), this.textColor);
    }

    public static class Deserializer
    extends BaseDeserializer {
        public Deserializer(Supplier<? extends Label> supplier) {
            super(supplier);
        }

        @Override
        public void parseHeight(String expr) {
            Font font = Minecraft.getInstance().font;
            if (expr.equals("0")) {
                BaseRenderable baseRenderable = this.getRenderable();
                Objects.requireNonNull(font);
                baseRenderable.setHeight(9);
            } else {
                super.parseHeight(expr);
            }
        }

        @Override
        public void parseWidth(String expr) {
            Font font = Minecraft.getInstance().font;
            if (expr.equals("0") && ((Label)this.getRenderable()).text != null) {
                this.getRenderable().setWidth(font.width((FormattedText)((Label)this.getRenderable()).text));
            } else {
                super.parseWidth(expr);
            }
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((Label)this.getRenderable()).text = this.parseComponent("text", obj);
            ((Label)this.getRenderable()).textColor = this.getOrDefault(obj, "text_color", -16777216);
            ((Label)this.getRenderable()).centered = this.getOrDefault(obj, "centered", false);
            this.parseWidth(this.getOrDefault(obj, "width", "0"));
            this.parseHeight(this.getOrDefault(obj, "height", "0"));
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }

    public static class Builder {
        private IEasyGuiScreen easyGuiScreen = null;
        private int textColor = -16777216;
        private boolean centered = false;
        private Integer width;
        private Integer height;
        private Component text = Component.literal((String)"");
        private Font font;
        private boolean cull;
        private boolean useCustomScaling;
        private double customScaling;
        private int x;
        private int y;

        public Builder() {
            this.font = Minecraft.getInstance().font;
            this.cull = false;
            this.useCustomScaling = false;
            this.customScaling = 1.0;
            this.x = 0;
            this.y = 0;
        }

        public Builder screen(IEasyGuiScreen easyGuiScreen) {
            this.easyGuiScreen = easyGuiScreen;
            return this;
        }

        public Builder textColor(int color) {
            this.textColor = color;
            return this;
        }

        public Builder textColor(Color color) {
            this.textColor = color.getRGB();
            return this;
        }

        public Builder centered(boolean centered) {
            this.centered = centered;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder text(Component component) {
            this.text = component;
            return this;
        }

        public Builder text(String text) {
            this.text = Component.literal((String)text);
            return this;
        }

        public Builder translatableText(String key) {
            this.text = Component.translatable((String)key);
            return this;
        }

        public Builder font(Font font) {
            this.font = font;
            return this;
        }

        public Builder cull(boolean cull) {
            this.cull = cull;
            return this;
        }

        public Builder customScaling(double scale) {
            this.useCustomScaling = true;
            this.customScaling = scale;
            return this;
        }

        public Builder x(int x) {
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            this.y = y;
            return this;
        }

        public Label build() {
            if (this.easyGuiScreen == null) {
                throw new IllegalArgumentException("Label must have a valid screen");
            }
            if (this.width == null) {
                this.width = this.font.width((FormattedText)this.text);
            }
            if (this.height == null) {
                Objects.requireNonNull(this.font);
                this.height = 9;
            }
            Label label = new Label(this.easyGuiScreen, this.font, this.text, this.x, this.y, this.width, this.height, this.centered, this.textColor);
            label.useCustomScaling = this.useCustomScaling;
            label.setCustomScale(this.customScaling);
            label.setCull(this.cull);
            return label;
        }
    }
}

