/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.elements.other;

import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.lucent.easygui.elements.BaseRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.interfaces.ITextureData;
import net.lucent.easygui.templating.IRenderableDeserializer;
import net.lucent.easygui.templating.deserializers.BaseDeserializer;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class ProgressBar
extends BaseRenderable {
    public ITextureData background;
    public ITextureData barTexture;
    public boolean vertical = false;
    public double progressPercent = 0.0;

    public ProgressBar() {
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, int x, int y) {
        super(easyGuiScreen);
        this.setX(x);
        this.setY(y);
        this.barTexture = progressBarTexture;
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, boolean vertical, int x, int y) {
        this(easyGuiScreen, progressBarTexture, x, y);
        this.barTexture = progressBarTexture;
        this.vertical = vertical;
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, ITextureData background, boolean vertical, int x, int y) {
        this(easyGuiScreen, progressBarTexture, vertical, x, y);
        this.background = background;
    }

    public ProgressBar(IEasyGuiScreen easyGuiScreen, ITextureData progressBarTexture, ITextureData background, int x, int y) {
        this(easyGuiScreen, progressBarTexture, x, y);
        this.background = background;
    }

    public double getProgress() {
        return this.progressPercent;
    }

    public int getProgressLength() {
        if (this.vertical) {
            return (int)((double)this.getHeight() * this.getProgress());
        }
        return (int)((double)this.getWidth() * this.getProgress());
    }

    @Override
    public int getWidth() {
        if (this.barTexture == null) {
            return 0;
        }
        if (this.background == null) {
            return this.barTexture.getWidth();
        }
        return Math.max(this.background.getWidth(), this.barTexture.getWidth());
    }

    @Override
    public int getHeight() {
        if (this.barTexture == null) {
            return 0;
        }
        if (this.background == null) {
            return this.barTexture.getHeight();
        }
        return Math.max(this.background.getHeight(), this.barTexture.getHeight());
    }

    @Override
    public void renderSelf(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            this.background.renderTexture(guiGraphics);
        }
        if (this.vertical) {
            this.barTexture.renderTexture(guiGraphics, 0, 0, 0, 0, this.barTexture.getWidth(), this.getProgressLength());
        } else {
            this.barTexture.renderTexture(guiGraphics, 0, 0, 0, 0, this.getProgressLength(), this.barTexture.getHeight());
        }
    }

    public void setBackground(ITextureData background) {
        System.out.println("SETTING BACKGROUND");
        System.out.println(background.getTexture());
        this.background = background;
    }

    public void setBarTexture(ITextureData barTexture) {
        this.barTexture = barTexture;
    }

    public static class Deserializer
    extends BaseDeserializer {
        public Deserializer(Supplier<? extends ProgressBar> supplier) {
            super(supplier);
        }

        @Override
        public void parseWidth(String expr) {
        }

        @Override
        public void parseHeight(String expr) {
        }

        @Override
        public void buildRenderable(IEasyGuiScreen screen, IRenderableDeserializer parent, JsonObject obj) {
            super.buildRenderable(screen, parent, obj);
            ((ProgressBar)this.getRenderable()).setBackground(this.parseTexture("background_texture", obj));
            ((ProgressBar)this.getRenderable()).setBarTexture(this.parseTexture("progress_texture", obj));
            ((ProgressBar)this.getRenderable()).vertical = this.getOrDefault(obj, "is_vertical", false);
        }

        @Override
        @NotNull
        public IRenderableDeserializer createInstance() {
            return new Deserializer(this.supplier);
        }
    }
}

