/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.interfaces;

import java.util.List;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.templating.actions.Action;
import net.lucent.easygui.templating.actions.IAction;
import net.lucent.easygui.util.math.BoundChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public interface ContainerRenderable
extends Renderable {
    public String getID();

    public List<String> getClassList();

    public void setID(String var1);

    public void addClass(String var1);

    public void removeClass(String var1);

    public void render(GuiGraphics var1, int var2, int var3, float var4);

    public void renderSelf(GuiGraphics var1, int var2, int var3, float var4);

    public void renderChildren(GuiGraphics var1, int var2, int var3, float var4);

    public void setRenderScale(GuiGraphics var1);

    public void resetRenderScale(GuiGraphics var1);

    default public boolean isActive() {
        return false;
    }

    public void setActive(boolean var1);

    default public boolean isVisible() {
        return false;
    }

    public void setVisible(boolean var1);

    default public boolean isFocused() {
        return false;
    }

    public void setFocused(boolean var1);

    public int getX();

    public int getY();

    public void setX(int var1);

    public void setY(int var1);

    default public void setRotation(double x, double y, double z) {
    }

    default public double getRotationX() {
        return 0.0;
    }

    default public double getRotationY() {
        return 0.0;
    }

    default public double getRotationZ() {
        return 0.0;
    }

    default public boolean usesMinecraftScaling() {
        return false;
    }

    default public double getTotalCustomScaling() {
        return 1.0;
    }

    default public double getTotalScaleFactorX() {
        return 1.0;
    }

    default public double getTotalScaleFactorY() {
        return 1.0;
    }

    default public double getGlobalScaledX() {
        return 0.0;
    }

    default public double getGlobalScaledY() {
        return 0.0;
    }

    public ContainerRenderable getParent();

    public ContainerRenderable getRoot();

    public List<ContainerRenderable> getChildren();

    default public int getWidth() {
        return 0;
    }

    default public int getHeight() {
        return 0;
    }

    default public int getCullBorderWidth() {
        return 0;
    }

    default public double getScale() {
        return 0.0;
    }

    default public double getScaleX() {
        return this.getScale();
    }

    default public double getScaleY() {
        return this.getScale();
    }

    default public int getScaledWidth() {
        return (int)((double)this.getWidth() * this.getTotalScaleFactorX());
    }

    default public int getScaledHeight() {
        return (int)((double)this.getHeight() * this.getTotalScaleFactorY());
    }

    public IEasyGuiScreen getScreen();

    public void setScreen(IEasyGuiScreen var1);

    public Matrix4f getTransform();

    public Matrix4f getPositionTransform();

    public void setParent(ContainerRenderable var1);

    public void addChild(ContainerRenderable var1);

    public void remove();

    default public BoundChecker.Vec2 screenToLocalPoint(double x, double y) {
        Vector3f position = new Matrix4f((Matrix4fc)this.getTransform()).invert().transformPosition(new Vector3f((float)x, (float)y, 0.0f));
        return new BoundChecker.Vec2((int)position.x, (int)position.y);
    }

    default public BoundChecker.Vec2 localToScreenPoint(double x, double y) {
        Vector3f position = new Matrix4f((Matrix4fc)this.getTransform()).transformPosition(new Vector3f((float)x, (float)y, 0.0f));
        return new BoundChecker.Vec2((int)position.x, (int)position.y);
    }

    default public void tick() {
    }

    public double getCustomScale();

    default public double getTotalCustomScale() {
        if (this.getParent() == null) {
            return this.getCustomScale();
        }
        return this.getParent().getTotalCustomScale() * this.getCustomScale();
    }

    default public double getApplicableMinecraftScale() {
        if (this.getRoot() != null && this.getRoot().usesMinecraftScaling()) {
            return Minecraft.getInstance().getWindow().getGuiScale();
        }
        return 1.0;
    }

    public void setCull(boolean var1);

    public boolean shouldCull();

    public void setWidth(int var1);

    public void setHeight(int var1);

    public void setTickAction(Action var1);

    public BoundChecker.Rec2d getActiveCullRegion();

    public static interface TickAction
    extends IAction {
        @Override
        default public void accept(ContainerRenderable renderable, Object[] eventArgs, Object[] customArgs) {
            this.run(renderable, customArgs);
        }

        @Override
        public void run(ContainerRenderable var1, Object[] var2);
    }
}

