/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.interfaces.complex_events;

import net.lucent.easygui.interfaces.events.Clickable;
import net.lucent.easygui.interfaces.events.MouseDragListener;
import net.lucent.easygui.interfaces.events.MouseReleaseListener;
import net.lucent.easygui.util.math.BoundChecker;

public interface Draggable
extends Clickable,
MouseDragListener,
MouseReleaseListener {
    public boolean isDragged();

    public void setDragged(boolean var1);

    public void setClickPosition(double var1, double var3);

    @Override
    default public void onClick(double mouseX, double mouseY, int button, boolean clicked) {
        if (clicked && button == 0) {
            this.setDragged(true);
            this.setClickPosition(mouseX, mouseY);
        }
    }

    default public int getClickPosX() {
        return 0;
    }

    default public int getClickPosY() {
        return 0;
    }

    @Override
    default public void onDrag(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragged() && button == 0) {
            BoundChecker.Vec2 localPoint = this.screenToLocalPoint(mouseX, mouseY);
            BoundChecker.Vec2 finalLocalPoint = new BoundChecker.Vec2(localPoint.x - this.getClickPosX(), localPoint.y - this.getClickPosY());
            BoundChecker.Vec2 screenPoint = this.localToScreenPoint(finalLocalPoint.x, finalLocalPoint.y);
            BoundChecker.Vec2 point = this.getParent().screenToLocalPoint(screenPoint.x, screenPoint.y);
            this.setX(point.x);
            this.setY(point.y);
        }
    }

    @Override
    default public void onMouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.setDragged(false);
        }
    }
}

