/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.overlays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.lucent.easygui.elements.containers.View;
import net.lucent.easygui.holders.EasyGuiEventHolder;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@OnlyIn(value=Dist.CLIENT)
public class EasyGuiOverlay
implements IEasyGuiScreen {
    public int windowWidth = Minecraft.getInstance().getWindow().getWidth();
    public int windowHeight = Minecraft.getInstance().getWindow().getHeight();
    public double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
    private View view;
    public EasyGuiEventHolder eventHolder = new EasyGuiEventHolder();
    public BiConsumer<EasyGuiEventHolder, EasyGuiOverlay> runnable;
    private final HashMap<String, ContainerRenderable> idMap = new HashMap();
    private final HashMap<String, List<ContainerRenderable>> classMap = new HashMap();

    public EasyGuiOverlay(BiConsumer<EasyGuiEventHolder, EasyGuiOverlay> initialize) {
        this.runnable = initialize;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    private void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.runnable.accept(this.eventHolder, this);
    }

    @SubscribeEvent
    private void onClientTick(ClientTickEvent.Pre event) {
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        this.eventHolder.TICK_EVENT.call();
        this.eventHolder.MOUSE_OVER_EVENT.call(mouseX, mouseY);
    }

    @SubscribeEvent
    public void onScroll(InputEvent.MouseScrollingEvent event) {
        this.eventHolder.MOUSE_SCROLL_EVENT.call(event.getMouseX(), event.getMouseY(), event.getScrollDeltaX(), event.getScrollDeltaY());
    }

    @SubscribeEvent
    public void onMouseClick(InputEvent.MouseButton.Pre event) {
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        if (event.getAction() == 1 || event.getAction() == 2) {
            this.eventHolder.CLICK_EVENT.call(mouseX, mouseY, event.getButton());
            return;
        }
        this.eventHolder.MOUSE_RELEASE_EVENT.call(mouseX, mouseY, event.getButton());
    }

    void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getWindow().getHeight() != this.windowHeight || this.windowWidth != mc.getWindow().getWidth()) {
            this.eventHolder.SCREEN_RESIZE_EVENT.call(this.windowWidth, this.windowHeight, this.guiScale);
            this.windowWidth = mc.getWindow().getWidth();
            this.windowHeight = mc.getWindow().getHeight();
            this.guiScale = mc.getWindow().getGuiScale();
        } else if (mc.getWindow().getGuiScale() != this.guiScale) {
            this.eventHolder.GUI_SCALE_CHANGED_EVENT.call(this.guiScale);
            this.guiScale = mc.getWindow().getGuiScale();
        }
        this.view.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void register(ContainerRenderable renderable) {
        this.eventHolder.register(renderable);
    }

    @Override
    public void unregister(ContainerRenderable renderable) {
        this.eventHolder.unregister(renderable);
    }

    @Override
    public void addView(View view) {
        this.view = view;
    }

    @Override
    public void removeView(View view) {
    }

    @Override
    public void childIdSet(ContainerRenderable obj, String id) {
        this.idMap.put(id, obj);
    }

    @Override
    public void childClassAdded(ContainerRenderable obj, String className) {
        if (!this.classMap.containsKey(className)) {
            this.classMap.put(className, new ArrayList());
        }
        this.classMap.get(className).add(obj);
    }

    @Override
    public void childClassRemoved(ContainerRenderable obj, String className) {
        if (!this.classMap.containsKey(className)) {
            return;
        }
        this.classMap.get(className).remove(obj);
    }

    @Override
    public ContainerRenderable getElementByID(String id) {
        return this.idMap.get(id);
    }

    @Override
    public List<ContainerRenderable> getElementsByClassName(String className) {
        if (!this.classMap.containsKey(className)) {
            return List.of();
        }
        return List.copyOf((Collection)this.classMap.get(className));
    }
}

