/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.overlays;

import java.util.HashMap;
import java.util.Map;
import net.lucent.easygui.overlays.EasyGuiOverlay;
import net.lucent.easygui.overlays.EasyGuiOverlayHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="easy_gui")
public class EasyGuiOverlayManager {
    public static final Map<ResourceLocation, EasyGuiOverlayHandler> customOverlayLayers = new HashMap<ResourceLocation, EasyGuiOverlayHandler>();
    public static final Map<ResourceLocation, EasyGuiOverlay> vanillaOverlayOverrides = new HashMap<ResourceLocation, EasyGuiOverlay>();

    public static void registerVanillaOverlayOverride(ResourceLocation name, EasyGuiOverlay overlay) {
        vanillaOverlayOverrides.put(name, overlay);
    }

    public static void addLayer(ResourceLocation name, EasyGuiOverlay overlay) {
        if (!customOverlayLayers.containsKey(name)) {
            customOverlayLayers.put(name, new EasyGuiOverlayHandler());
        }
        EasyGuiOverlayManager.customOverlayLayers.get((Object)name).overlays.add(overlay);
    }

    public static void onRegisterOverlays(RegisterGuiLayersEvent event) {
        for (Map.Entry<ResourceLocation, EasyGuiOverlayHandler> entry : customOverlayLayers.entrySet()) {
            event.registerAboveAll(entry.getKey(), (LayeredDraw.Layer)entry.getValue());
        }
    }

    @SubscribeEvent
    public static void onRenderGuiLayer(RenderGuiLayerEvent.Pre event) {
        if (vanillaOverlayOverrides.containsKey(event.getName())) {
            event.setCanceled(true);
            Minecraft mc = Minecraft.getInstance();
            vanillaOverlayOverrides.get(event.getName()).render(event.getGuiGraphics(), (int)mc.mouseHandler.xpos(), (int)mc.mouseHandler.ypos(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
        }
    }
}

