/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.screens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.lucent.easygui.elements.containers.View;
import net.lucent.easygui.holders.EasyGuiEventHolder;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.lucent.easygui.util.inventory.EasySlot;
import net.lucent.easygui.util.math.BoundChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class EasyGuiContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IEasyGuiScreen {
    public int windowWidth = Minecraft.getInstance() != null ? Minecraft.getInstance().getWindow().getWidth() : 0;
    public int windowHeight = Minecraft.getInstance() != null ? Minecraft.getInstance().getWindow().getHeight() : 0;
    public double guiScale = Minecraft.getInstance() != null ? Minecraft.getInstance().getWindow().getGuiScale() : 0.0;
    private final List<View> views = new ArrayList<View>();
    private final EasyGuiEventHolder eventHolder = new EasyGuiEventHolder();
    private final HashMap<String, ContainerRenderable> idMap = new HashMap();
    private final HashMap<String, List<ContainerRenderable>> classMap = new HashMap();

    public EasyGuiContainerScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    public EasyGuiEventHolder getEventHolder() {
        return this.eventHolder;
    }

    @Override
    public void addView(View view) {
        this.views.add(view);
    }

    protected void init() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getWindow().getHeight() != this.windowHeight || this.windowWidth != mc.getWindow().getWidth()) {
            this.eventHolder.SCREEN_RESIZE_EVENT.call(this.windowWidth, this.windowHeight, this.guiScale);
            this.windowWidth = mc.getWindow().getWidth();
            this.windowHeight = mc.getWindow().getHeight();
            this.guiScale = mc.getWindow().getGuiScale();
        } else if (mc.getWindow().getGuiScale() != this.guiScale) {
            this.guiScale = mc.getWindow().getGuiScale();
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        for (View view : this.views) {
            if (!view.isActive()) continue;
            view.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void register(ContainerRenderable renderable) {
        this.eventHolder.register(renderable);
    }

    @Override
    public void unregister(ContainerRenderable renderable) {
        this.eventHolder.unregister(renderable);
    }

    @Override
    public void removeView(View view) {
        this.views.remove(view);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.eventHolder.MOUSE_MOVED_EVENT.call(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.eventHolder.MOUSE_SCROLL_EVENT.call(mouseX, mouseY, scrollX, scrollY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.eventHolder.KEY_PRESS_EVENT.call(keyCode, scanCode, modifiers);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.eventHolder.KEY_RELEASED_EVENT.call(keyCode, scanCode, modifiers);
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        this.eventHolder.CHAR_TYPED_EVENT.call(codePoint, modifiers);
        return super.charTyped(codePoint, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.eventHolder.CLICK_EVENT.call(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.eventHolder.MOUSE_RELEASE_EVENT.call(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.eventHolder.MOUSE_DRAG_EVENT.call(mouseX, mouseY, button, dragX, dragY);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void containerTick() {
        super.containerTick();
        double scale = ((Integer)Minecraft.getInstance().options.guiScale().get()).intValue();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        this.eventHolder.MOUSE_OVER_EVENT.call(mouseX / scale, mouseY / scale);
        this.eventHolder.TICK_EVENT.call();
    }

    @Override
    public void childIdSet(ContainerRenderable obj, String id) {
        this.idMap.put(id, obj);
    }

    @Override
    public void childClassAdded(ContainerRenderable obj, String className) {
        if (!this.classMap.containsKey(className)) {
            this.classMap.put(className, new ArrayList());
        }
        this.classMap.get(className).add(obj);
    }

    @Override
    public void childClassRemoved(ContainerRenderable obj, String className) {
        if (!this.classMap.containsKey(className)) {
            return;
        }
        this.classMap.get(className).remove(obj);
    }

    @Override
    public ContainerRenderable getElementByID(String id) {
        return this.idMap.get(id);
    }

    @Override
    public List<ContainerRenderable> getElementsByClassName(String className) {
        if (!this.classMap.containsKey(className)) {
            return List.of();
        }
        return List.copyOf((Collection)this.classMap.get(className));
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        EasySlot easySlot;
        guiGraphics.pose().pushPose();
        if (slot instanceof EasySlot) {
            easySlot = (EasySlot)slot;
            easySlot.updatePose();
            if (easySlot.pose != null) {
                guiGraphics.pose().mulPose(easySlot.pose);
            }
            if (!easySlot.slot.isVisible()) {
                guiGraphics.pose().popPose();
                return;
            }
            if (easySlot.slot.getActiveCullRegion() != null) {
                BoundChecker.Rec2d activeRegion = easySlot.slot.getActiveCullRegion();
                guiGraphics.enableScissor(activeRegion.p1.x, activeRegion.p1.y, activeRegion.p3.x, activeRegion.p3.y);
            }
        }
        super.renderSlot(guiGraphics, slot);
        if (slot instanceof EasySlot) {
            easySlot = (EasySlot)slot;
            if (easySlot.slot.getActiveCullRegion() != null) {
                guiGraphics.disableScissor();
            }
        }
        guiGraphics.pose().popPose();
    }

    protected void renderSlotHighlight(GuiGraphics guiGraphics, Slot slot, int mouseX, int mouseY, float partialTick) {
        EasySlot easySlot;
        guiGraphics.pose().pushPose();
        if (slot instanceof EasySlot) {
            easySlot = (EasySlot)slot;
            easySlot.updatePose();
            if (easySlot.posPose != null) {
                guiGraphics.pose().mulPose(easySlot.posPose);
            }
            if (!easySlot.slot.isVisible()) {
                guiGraphics.pose().popPose();
                return;
            }
            if (easySlot.slot.getActiveCullRegion() != null) {
                BoundChecker.Rec2d activeRegion = easySlot.slot.getActiveCullRegion();
                guiGraphics.enableScissor(activeRegion.p1.x, activeRegion.p1.y, activeRegion.p3.x, activeRegion.p3.y);
            }
        }
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        super.renderSlotHighlight(guiGraphics, slot, mouseX, mouseY, partialTick);
        if (slot instanceof EasySlot) {
            easySlot = (EasySlot)slot;
            if (easySlot.slot.getActiveCullRegion() != null) {
                guiGraphics.disableScissor();
            }
        }
        guiGraphics.pose().popPose();
    }

    public boolean isHovering(Slot slot, double mouseX, double mouseY) {
        if (slot instanceof EasySlot) {
            EasySlot easySlot = (EasySlot)slot;
            return easySlot.slot.isMouseOver(mouseX, mouseY);
        }
        return super.isHovering(slot, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }
}

