/*
 * Decompiled with CFR 0.152.
 */
package net.lucent.easygui.screens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.lucent.easygui.elements.containers.View;
import net.lucent.easygui.holders.EasyGuiEventHolder;
import net.lucent.easygui.interfaces.ContainerRenderable;
import net.lucent.easygui.interfaces.IEasyGuiScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class EasyGuiScreen
extends Screen
implements IEasyGuiScreen {
    public int windowWidth = Minecraft.getInstance() != null ? Minecraft.getInstance().getWindow().getWidth() : 0;
    public int windowHeight = Minecraft.getInstance() != null ? Minecraft.getInstance().getWindow().getHeight() : 0;
    public double guiScale = Minecraft.getInstance() != null ? Minecraft.getInstance().getWindow().getGuiScale() : 0.0;
    private final List<View> views = new ArrayList<View>();
    private final EasyGuiEventHolder eventHolder = new EasyGuiEventHolder();
    private final HashMap<String, ContainerRenderable> idMap = new HashMap();
    private final HashMap<String, List<ContainerRenderable>> classMap = new HashMap();
    private View activeView = null;

    public EasyGuiScreen(Component title) {
        super(title);
    }

    public EasyGuiEventHolder getEventHolder() {
        return this.eventHolder;
    }

    @Override
    public void addView(View view) {
        this.views.add(view);
        view.setActive(false);
        System.out.println(this.views);
    }

    protected void init() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getWindow().getHeight() != this.windowHeight || this.windowWidth != mc.getWindow().getWidth()) {
            this.eventHolder.SCREEN_RESIZE_EVENT.call(this.windowWidth, this.windowHeight, this.guiScale);
            this.windowWidth = mc.getWindow().getWidth();
            this.windowHeight = mc.getWindow().getHeight();
            this.guiScale = mc.getWindow().getGuiScale();
        } else if (mc.getWindow().getGuiScale() != this.guiScale) {
            this.guiScale = mc.getWindow().getGuiScale();
        }
    }

    @Override
    public void setActiveView(View view) {
        for (View disableView : this.views) {
            disableView.setActive(false);
        }
        view.setActive(true);
        this.activeView = view;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.activeView == null) {
            System.out.println(this.views);
            System.out.println(this.views.getFirst());
            this.setActiveView(this.views.getFirst());
        }
        this.activeView.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void register(ContainerRenderable renderable) {
        this.eventHolder.register(renderable);
    }

    @Override
    public void unregister(ContainerRenderable renderable) {
        this.eventHolder.unregister(renderable);
    }

    @Override
    public void removeView(View view) {
        this.views.remove(view);
    }

    @Override
    public void childIdSet(ContainerRenderable obj, String id) {
        this.idMap.put(id, obj);
    }

    @Override
    public void childClassAdded(ContainerRenderable obj, String className) {
        if (!this.classMap.containsKey(className)) {
            this.classMap.put(className, new ArrayList());
        }
        this.classMap.get(className).add(obj);
    }

    @Override
    public void childClassRemoved(ContainerRenderable obj, String className) {
        if (!this.classMap.containsKey(className)) {
            return;
        }
        this.classMap.get(className).remove(obj);
    }

    @Override
    public ContainerRenderable getElementByID(String id) {
        System.out.println(this.idMap);
        System.out.println(id);
        System.out.println(this.idMap.get(id));
        return this.idMap.get(id);
    }

    @Override
    public List<ContainerRenderable> getElementsByClassName(String className) {
        if (!this.classMap.containsKey(className)) {
            return List.of();
        }
        return List.copyOf((Collection)this.classMap.get(className));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.eventHolder.KEY_PRESS_EVENT.call(keyCode, scanCode, modifiers);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.eventHolder.MOUSE_MOVED_EVENT.call(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.eventHolder.MOUSE_SCROLL_EVENT.call(mouseX, mouseY, scrollX, scrollY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.eventHolder.KEY_RELEASED_EVENT.call(keyCode, scanCode, modifiers);
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        this.eventHolder.CHAR_TYPED_EVENT.call(codePoint, modifiers);
        return super.charTyped(codePoint, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.eventHolder.CLICK_EVENT.call(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.eventHolder.MOUSE_RELEASE_EVENT.call(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.eventHolder.MOUSE_DRAG_EVENT.call(mouseX, mouseY, button, dragX, dragY);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        double mouseX = Minecraft.getInstance().mouseHandler.xpos();
        double mouseY = Minecraft.getInstance().mouseHandler.ypos();
        this.eventHolder.MOUSE_OVER_EVENT.call(mouseX / this.guiScale, mouseY / this.guiScale);
        this.eventHolder.TICK_EVENT.call();
    }
}

